import { aws_ecs as ecs, aws_elasticloadbalancingv2 as elbv2, aws_codedeploy as codedeploy, aws_logs as logs, aws_iam as iam, aws_ec2 as ec2 } from "aws-cdk-lib";
import { Construct } from "constructs";
import { ContainerProps, AutoScalingProps, LoadBalancerConfig, CodeDeployConfig } from "./interface";
/**
 * Creates and configures an ECS Fargate service with task definition and containers
 */
export declare class EcsServiceComponent extends Construct {
    readonly service: ecs.FargateService;
    readonly taskDef: ecs.TaskDefinition;
    readonly containers: ecs.ContainerDefinition[];
    readonly logGroup: logs.LogGroup;
    readonly taskRole: iam.IRole;
    readonly taskExecutionRole: iam.IRole;
    constructor(scope: Construct, id: string, props: {
        vpc: ec2.IVpc;
        cluster: ecs.ICluster;
        serviceName: string;
        containers: ContainerProps[];
        taskRole?: iam.IRole;
        taskExecRole?: iam.IRole;
        taskCPU?: number;
        memoryLimit?: number;
        securityGroups?: ec2.ISecurityGroup[];
        subnets?: ec2.SubnetSelection;
        assignPublicIp?: boolean;
        autoScaling?: AutoScalingProps;
        tags?: Record<string, string>;
        desiredCount?: number;
        healthCheckGracePeriod?: number;
        deploymentController?: ecs.DeploymentController;
    });
    /**
     * Extract the repository name from an ECR image URI
     */
    private getRepositoryNameFromImage;
    /**
     * Add containers to the task definition
     */
    private addContainers;
    /**
     * Set up auto-scaling for the service
     */
    private setupAutoScaling;
}
/**
 * Creates and configures an Application Load Balancer with listeners and target groups
 */
export declare class LoadBalancerComponent extends Construct {
    readonly loadBalancer: elbv2.ApplicationLoadBalancer;
    readonly productionListener: elbv2.ApplicationListener;
    readonly testListener: elbv2.ApplicationListener;
    readonly productionTargetGroup: elbv2.ApplicationTargetGroup;
    readonly testTargetGroup: elbv2.ApplicationTargetGroup;
    constructor(scope: Construct, id: string, props: {
        vpc: ec2.IVpc;
        serviceName: string;
        service: ecs.IService;
        targetPort: number;
        loadBalancerConfig?: LoadBalancerConfig;
        subnets?: ec2.SubnetSelection;
        tags?: Record<string, string>;
    });
    /**
     * Find an existing listener or create a new one
     */
    private findOrCreateListener;
    /**
     * Create a health check configuration from the provided config or defaults
     */
    private createHealthCheck;
}
/**
 * Creates and configures a CodeDeploy application and deployment group
 */
export declare class CodeDeployComponent extends Construct {
    readonly application: codedeploy.EcsApplication;
    readonly deploymentGroup: codedeploy.EcsDeploymentGroup;
    constructor(scope: Construct, id: string, props: {
        appName: string;
        service: ecs.IBaseService;
        productionListener: elbv2.IApplicationListener;
        testListener: elbv2.IApplicationListener;
        productionTargetGroup: elbv2.IApplicationTargetGroup;
        testTargetGroup: elbv2.IApplicationTargetGroup;
        config?: CodeDeployConfig;
        tags?: Record<string, string>;
    });
    private getDeploymentConfig;
}
