# Amplify Gen 2 + Vite + React + TypeScript

This template provides a minimal setup to get React working with Vite, TypeScript, and AWS Amplify Gen 2.

## Features

- ⚡️ **Vite** - Fast build tool and dev server
- ⚛️ **React 18** - Latest React with TypeScript
- 🔐 **Authentication** - Built-in user authentication with Cognito
- 📊 **Data** - GraphQL API with real-time subscriptions
- 📁 **Storage** - File upload and management with S3
- 🎨 **UI Components** - Pre-built Amplify UI components
- 🔧 **TypeScript** - Full type safety

## Getting Started

### Prerequisites

- Node.js 18+ and npm
- AWS CLI configured with appropriate permissions
- Amplify CLI v12+ (`npm install -g @aws-amplify/cli`)

### Local Development

1. **Install dependencies:**
   ```bash
   npm install
   ```

2. **Start the development server:**
   ```bash
   npm run dev
   ```

3. **Deploy the backend (first time):**
   ```bash
   npx ampx sandbox
   ```

   This will:
   - Deploy your backend to AWS
   - Generate the `amplify_outputs.json` file
   - Set up authentication, API, and storage

4. **Open your browser:**
   Navigate to `http://localhost:5173`

### Available Scripts

- `npm run dev` - Start development server
- `npm run build` - Build for production
- `npm run preview` - Preview production build locally
- `npm run lint` - Run ESLint

### Backend Resources

This template includes:

- **Authentication**: Email-based sign up/sign in
- **API**: GraphQL API with Note model
- **Storage**: S3 bucket for file uploads

### Project Structure

```
├── amplify/                 # Backend configuration
│   ├── auth/resource.ts     # Authentication setup
│   ├── data/resource.ts     # GraphQL API and database
│   └── backend.ts           # Backend definition
├── src/                     # Frontend source code
│   ├── App.tsx             # Main application component
│   └── main.tsx            # Application entry point
├── amplify_outputs.json    # Generated backend configuration
└── package.json            # Dependencies and scripts
```

### Deployment

#### Option 1: Amplify Hosting (Recommended)

1. **Connect your repository to Amplify Console**
2. **The `amplify.yml` file will automatically configure the build**
3. **Your app will be deployed with CI/CD**

#### Option 2: Manual Deployment

```bash
# Build the app
npm run build

# Deploy to your preferred hosting service
# The built files will be in the `dist/` directory
```

### Learn More

- [AWS Amplify Gen 2 Documentation](https://docs.amplify.aws/react/)
- [Vite Documentation](https://vitejs.dev/)
- [React Documentation](https://react.dev/)
- [TypeScript Documentation](https://www.typescriptlang.org/)

### Troubleshooting

- **Build errors**: Make sure you have Node.js 18+ installed
- **Backend issues**: Run `npx ampx sandbox --once` to redeploy
- **Type errors**: The `amplify_outputs.json` file must exist for TypeScript to work properly
