"""This file contains named colors for use in the GUI."""
#  MIT Licence
#  Copyright (c) 2024 Asger Jon Vistisen
from __future__ import annotations

from PySide6.QtGui import QColor


class ColorSpace:
  """Color space class"""
  AliceBlue = QColor(240, 248, 255)
  AntiqueWhite = QColor(250, 235, 215)
  Aqua = QColor(0, 255, 255)
  Aquamarine = QColor(127, 255, 212)
  Azure = QColor(240, 255, 255)
  Beige = QColor(245, 245, 220)
  Bisque = QColor(255, 228, 196)
  Black = QColor(0, 0, 0)
  BlanchedAlmond = QColor(255, 235, 205)
  Blue = QColor(0, 0, 255)
  BlueViolet = QColor(138, 43, 226)
  Brown = QColor(165, 42, 42)
  BurlyWood = QColor(222, 184, 135)
  CadetBlue = QColor(95, 158, 160)
  Chartreuse = QColor(127, 255, 0)
  Chocolate = QColor(210, 105, 30)
  Coral = QColor(255, 127, 80)
  CornflowerBlue = QColor(100, 149, 237)
  Cornsilk = QColor(255, 248, 220)
  Crimson = QColor(220, 20, 60)
  Cyan = QColor(0, 255, 255)
  DarkBlue = QColor(0, 0, 139)
  DarkCyan = QColor(0, 139, 139)
  DarkGoldenRod = QColor(184, 134, 11)
  DarkGray = QColor(169, 169, 169)
  DarkGreen = QColor(0, 100, 0)
  DarkKhaki = QColor(189, 183, 107)
  DarkMagenta = QColor(139, 0, 139)
  DarkOliveGreen = QColor(85, 107, 47)
  DarkOrange = QColor(255, 140, 0)
  DarkOrchid = QColor(153, 50, 204)
  DarkRed = QColor(139, 0, 0)
  DarkSalmon = QColor(233, 150, 122)
  DarkSeaGreen = QColor(143, 188, 143)
  DarkSlateBlue = QColor(72, 61, 139)
  DarkSlateGray = QColor(47, 79, 79)
  DarkTurquoise = QColor(0, 206, 209)
  DarkViolet = QColor(148, 0, 211)
  DeepPink = QColor(255, 20, 147)
  DeepSkyBlue = QColor(0, 191, 255)
  DimGray = QColor(105, 105, 105)
  DodgerBlue = QColor(30, 144, 255)
  FireBrick = QColor(178, 34, 34)
  FloralWhite = QColor(255, 250, 240)
  ForestGreen = QColor(34, 139, 34)
  Fuchsia = QColor(255, 0, 255)
  Gainsboro = QColor(220, 220, 220)
  GhostWhite = QColor(248, 248, 255)
  Gold = QColor(255, 215, 0)
  GoldenRod = QColor(218, 165, 32)
  Gray = QColor(128, 128, 128)
  Green = QColor(0, 128, 0)
  GreenYellow = QColor(173, 255, 47)
  HoneyDew = QColor(240, 255, 240)
  HotPink = QColor(255, 105, 180)
  IndianRed = QColor(205, 92, 92)
  Indigo = QColor(75, 0, 130)
  Ivory = QColor(255, 255, 240)
  Khaki = QColor(240, 230, 140)
  Lavender = QColor(230, 230, 250)
  LavenderBlush = QColor(255, 240, 245)
  LawnGreen = QColor(124, 252, 0)
  LemonChiffon = QColor(255, 250, 205)
  LightBlue = QColor(173, 216, 230)
  LightCoral = QColor(240, 128, 128)
  LightCyan = QColor(224, 255, 255)
  LightGoldenRodYellow = QColor(250, 250, 210)
  LightGray = QColor(211, 211, 211)
  LightGreen = QColor(144, 238, 144)
  LightPink = QColor(255, 182, 193)
  LightSalmon = QColor(255, 160, 122)
  LightSeaGreen = QColor(32, 178, 170)
  LightSkyBlue = QColor(135, 206, 250)
  LightSlateGray = QColor(119, 136, 153)
  LightSteelBlue = QColor(176, 224, 230)
  LightYellow = QColor(255, 255, 224)
  Lime = QColor(0, 255, 0)
  LimeGreen = QColor(50, 205, 50)
  Linen = QColor(250, 240, 230)
  Magenta = QColor(255, 0, 255)
  Maroon = QColor(128, 0, 0)
  MediumAquaMarine = QColor(102, 205, 170)
  MediumBlue = QColor(0, 0, 205)
  MediumOrchid = QColor(186, 85, 211)
  MediumPurple = QColor(147, 112, 219)
  MediumSeaGreen = QColor(60, 179, 113)
  MediumSlateBlue = QColor(123, 104, 238)
  MediumSpringGreen = QColor(0, 250, 154)
  MediumTurquoise = QColor(72, 209, 204)
  MediumVioletRed = QColor(199, 21, 133)
  MidnightBlue = QColor(25, 25, 112)
  MintCream = QColor(245, 255, 250)
  MistyRose = QColor(255, 228, 225)
  Moccasin = QColor(255, 228, 181)
  NavajoWhite = QColor(255, 222, 173)
  Navy = QColor(0, 0, 128)
  OldLace = QColor(253, 245, 230)
  Olive = QColor(128, 128, 0)
  OliveDrab = QColor(107, 142, 35)
  Orange = QColor(255, 165, 0)
  OrangeRed = QColor(255, 69, 0)
  Orchid = QColor(218, 112, 214)
  PaleGoldenRod = QColor(238, 232, 170)
  PaleGreen = QColor(152, 251, 152)
  PaleTurquoise = QColor(175, 238, 238)
  PaleVioletRed = QColor(219, 112, 147)
  PapayaWhip = QColor(255, 239, 213)
  PeachPuff = QColor(255, 218, 185)
  Peru = QColor(205, 133, 63)
  Pink = QColor(255, 192, 203)
  Plum = QColor(221, 160, 221)
  PowderBlue = QColor(176, 224, 230)
  Purple = QColor(128, 0, 128)
  RebeccaPurple = QColor(102, 51, 153)
  Red = QColor(255, 0, 0)
  RosyBrown = QColor(188, 143, 143)
  RoyalBlue = QColor(65, 105, 225)
  SaddleBrown = QColor(139, 69, 19)
  Salmon = QColor(250, 128, 114)
  SandyBrown = QColor(244, 164, 96)
  SeaGreen = QColor(46, 139, 87)
  SeaShell = QColor(255, 245, 238)
  Sienna = QColor(160, 82, 45)
  Silver = QColor(192, 192, 192)
  SkyBlue = QColor(135, 206, 235)
  SlateBlue = QColor(106, 90, 205)
  SlateGray = QColor(112, 128, 144)
  Snow = QColor(255, 250, 250)
  SpringGreen = QColor(0, 255, 127)
  SteelBlue = QColor(70, 130, 180)
  Tan = QColor(210, 180, 140)
  Teal = QColor(0, 128, 128)
  Thistle = QColor(216, 191, 216)
  Tomato = QColor(255, 99, 71)
  Turquoise = QColor(64, 224, 208)
  Violet = QColor(238, 130, 238)
  Wheat = QColor(245, 222, 179)
  White = QColor(255, 255, 255)
  WhiteSmoke = QColor(245, 245, 245)
  Yellow = QColor(255, 255, 0)
  YellowGreen = QColor(154, 205, 50)


AliceBlue = QColor(240, 248, 255)
AntiqueWhite = QColor(250, 235, 215)
Aqua = QColor(0, 255, 255)
Aquamarine = QColor(127, 255, 212)
Azure = QColor(240, 255, 255)
Beige = QColor(245, 245, 220)
Bisque = QColor(255, 228, 196)
Black = QColor(0, 0, 0)
BlanchedAlmond = QColor(255, 235, 205)
Blue = QColor(0, 0, 255)
BlueViolet = QColor(138, 43, 226)
Brown = QColor(165, 42, 42)
BurlyWood = QColor(222, 184, 135)
CadetBlue = QColor(95, 158, 160)
Chartreuse = QColor(127, 255, 0)
Chocolate = QColor(210, 105, 30)
Coral = QColor(255, 127, 80)
CornflowerBlue = QColor(100, 149, 237)
Cornsilk = QColor(255, 248, 220)
Crimson = QColor(220, 20, 60)
Cyan = QColor(0, 255, 255)
DarkBlue = QColor(0, 0, 139)
DarkCyan = QColor(0, 139, 139)
DarkGoldenRod = QColor(184, 134, 11)
DarkGray = QColor(169, 169, 169)
DarkGreen = QColor(0, 100, 0)
DarkKhaki = QColor(189, 183, 107)
DarkMagenta = QColor(139, 0, 139)
DarkOliveGreen = QColor(85, 107, 47)
DarkOrange = QColor(255, 140, 0)
DarkOrchid = QColor(153, 50, 204)
DarkRed = QColor(139, 0, 0)
DarkSalmon = QColor(233, 150, 122)
DarkSeaGreen = QColor(143, 188, 143)
DarkSlateBlue = QColor(72, 61, 139)
DarkSlateGray = QColor(47, 79, 79)
DarkTurquoise = QColor(0, 206, 209)
DarkViolet = QColor(148, 0, 211)
DeepPink = QColor(255, 20, 147)
DeepSkyBlue = QColor(0, 191, 255)
DimGray = QColor(105, 105, 105)
DodgerBlue = QColor(30, 144, 255)
FireBrick = QColor(178, 34, 34)
FloralWhite = QColor(255, 250, 240)
ForestGreen = QColor(34, 139, 34)
Fuchsia = QColor(255, 0, 255)
Gainsboro = QColor(220, 220, 220)
GhostWhite = QColor(248, 248, 255)
Gold = QColor(255, 215, 0)
GoldenRod = QColor(218, 165, 32)
Gray = QColor(128, 128, 128)
Green = QColor(0, 128, 0)
GreenYellow = QColor(173, 255, 47)
HoneyDew = QColor(240, 255, 240)
HotPink = QColor(255, 105, 180)
IndianRed = QColor(205, 92, 92)
Indigo = QColor(75, 0, 130)
Ivory = QColor(255, 255, 240)
Khaki = QColor(240, 230, 140)
Lavender = QColor(230, 230, 250)
LavenderBlush = QColor(255, 240, 245)
LawnGreen = QColor(124, 252, 0)
LemonChiffon = QColor(255, 250, 205)
LightBlue = QColor(173, 216, 230)
LightCoral = QColor(240, 128, 128)
LightCyan = QColor(224, 255, 255)
LightGoldenRodYellow = QColor(250, 250, 210)
LightGray = QColor(211, 211, 211)
LightGreen = QColor(144, 238, 144)
LightPink = QColor(255, 182, 193)
LightSalmon = QColor(255, 160, 122)
LightSeaGreen = QColor(32, 178, 170)
LightSkyBlue = QColor(135, 206, 250)
LightSlateGray = QColor(119, 136, 153)
LightSteelBlue = QColor(176, 224, 230)
LightYellow = QColor(255, 255, 224)
Lime = QColor(0, 255, 0)
LimeGreen = QColor(50, 205, 50)
Linen = QColor(250, 240, 230)
Magenta = QColor(255, 0, 255)
Maroon = QColor(128, 0, 0)
MediumAquaMarine = QColor(102, 205, 170)
MediumBlue = QColor(0, 0, 205)
MediumOrchid = QColor(186, 85, 211)
MediumPurple = QColor(147, 112, 219)
MediumSeaGreen = QColor(60, 179, 113)
MediumSlateBlue = QColor(123, 104, 238)
MediumSpringGreen = QColor(0, 250, 154)
MediumTurquoise = QColor(72, 209, 204)
MediumVioletRed = QColor(199, 21, 133)
MidnightBlue = QColor(25, 25, 112)
MintCream = QColor(245, 255, 250)
MistyRose = QColor(255, 228, 225)
Moccasin = QColor(255, 228, 181)
NavajoWhite = QColor(255, 222, 173)
Navy = QColor(0, 0, 128)
OldLace = QColor(253, 245, 230)
Olive = QColor(128, 128, 0)
OliveDrab = QColor(107, 142, 35)
Orange = QColor(255, 165, 0)
OrangeRed = QColor(255, 69, 0)
Orchid = QColor(218, 112, 214)
PaleGoldenRod = QColor(238, 232, 170)
PaleGreen = QColor(152, 251, 152)
PaleTurquoise = QColor(175, 238, 238)
PaleVioletRed = QColor(219, 112, 147)
PapayaWhip = QColor(255, 239, 213)
PeachPuff = QColor(255, 218, 185)
Peru = QColor(205, 133, 63)
Pink = QColor(255, 192, 203)
Plum = QColor(221, 160, 221)
PowderBlue = QColor(176, 224, 230)
Purple = QColor(128, 0, 128)
RebeccaPurple = QColor(102, 51, 153)
Red = QColor(255, 0, 0)
RosyBrown = QColor(188, 143, 143)
RoyalBlue = QColor(65, 105, 225)
SaddleBrown = QColor(139, 69, 19)
Salmon = QColor(250, 128, 114)
SandyBrown = QColor(244, 164, 96)
SeaGreen = QColor(46, 139, 87)
SeaShell = QColor(255, 245, 238)
Sienna = QColor(160, 82, 45)
Silver = QColor(192, 192, 192)
SkyBlue = QColor(135, 206, 235)
SlateBlue = QColor(106, 90, 205)
SlateGray = QColor(112, 128, 144)
Snow = QColor(255, 250, 250)
SpringGreen = QColor(0, 255, 127)
SteelBlue = QColor(70, 130, 180)
Tan = QColor(210, 180, 140)
Teal = QColor(0, 128, 128)
Thistle = QColor(216, 191, 216)
Tomato = QColor(255, 99, 71)
Turquoise = QColor(64, 224, 208)
Violet = QColor(238, 130, 238)
Wheat = QColor(245, 222, 179)
White = QColor(255, 255, 255)
WhiteSmoke = QColor(245, 245, 245)
Yellow = QColor(255, 255, 0)
YellowGreen = QColor(154, 205, 50)

greyDict = {
  'Black'        : QColor(0, 0, 0, ),
  'DimGray'      : QColor(105, 105, 105, ),
  'Gray'         : QColor(128, 128, 128, ),
  'DarkGray'     : QColor(169, 169, 169, ),
  'Silver'       : QColor(192, 192, 192, ),
  'LightGray'    : QColor(211, 211, 211, ),
  'Gainsboro'    : QColor(220, 220, 220, ),
  'HoneyDew'     : QColor(240, 255, 240, ),
  'WhiteSmoke'   : QColor(245, 245, 245, ),
  'LavenderBlush': QColor(255, 240, 245, ),
  'AliceBlue'    : QColor(240, 248, 255, ),
  'FloralWhite'  : QColor(255, 250, 240, ),
  'Azure'        : QColor(240, 255, 255, ),
  'Ivory'        : QColor(255, 255, 240, ),
  'MintCream'    : QColor(245, 255, 250, ),
  'GhostWhite'   : QColor(248, 248, 255, ),
  'Snow'         : QColor(255, 250, 250, ),
  'White'        : QColor(255, 255, 255, ),
}

colorDict = {
  'AliceBlue'           : QColor(240, 248, 255, ),
  'AntiqueWhite'        : QColor(250, 235, 215, ),
  'Aqua'                : QColor(0, 255, 255, ),
  'Aquamarine'          : QColor(127, 255, 212, ),
  'Azure'               : QColor(240, 255, 255, ),
  'Beige'               : QColor(245, 245, 220, ),
  'Bisque'              : QColor(255, 228, 196, ),
  'Black'               : QColor(0, 0, 0, ),
  'BlanchedAlmond'      : QColor(255, 235, 205, ),
  'Blue'                : QColor(0, 0, 255, ),
  'BlueViolet'          : QColor(138, 43, 226, ),
  'Brown'               : QColor(165, 42, 42, ),
  'BurlyWood'           : QColor(222, 184, 135, ),
  'CadetBlue'           : QColor(95, 158, 160, ),
  'Chartreuse'          : QColor(127, 255, 0, ),
  'Chocolate'           : QColor(210, 105, 30, ),
  'Coral'               : QColor(255, 127, 80, ),
  'CornflowerBlue'      : QColor(100, 149, 237, ),
  'Cornsilk'            : QColor(255, 248, 220, ),
  'Crimson'             : QColor(220, 20, 60, ),
  'Cyan'                : QColor(0, 255, 255, ),
  'DarkBlue'            : QColor(0, 0, 139, ),
  'DarkCyan'            : QColor(0, 139, 139, ),
  'DarkGoldenRod'       : QColor(184, 134, 11, ),
  'DarkGray'            : QColor(169, 169, 169, ),
  'DarkGreen'           : QColor(0, 100, 0, ),
  'DarkKhaki'           : QColor(189, 183, 107, ),
  'DarkMagenta'         : QColor(139, 0, 139, ),
  'DarkOliveGreen'      : QColor(85, 107, 47, ),
  'DarkOrange'          : QColor(255, 140, 0, ),
  'DarkOrchid'          : QColor(153, 50, 204, ),
  'DarkRed'             : QColor(139, 0, 0, ),
  'DarkSalmon'          : QColor(233, 150, 122, ),
  'DarkSeaGreen'        : QColor(143, 188, 143, ),
  'DarkSlateBlue'       : QColor(72, 61, 139, ),
  'DarkSlateGray'       : QColor(47, 79, 79, ),
  'DarkTurquoise'       : QColor(0, 206, 209, ),
  'DarkViolet'          : QColor(148, 0, 211, ),
  'DeepPink'            : QColor(255, 20, 147, ),
  'DeepSkyBlue'         : QColor(0, 191, 255, ),
  'DimGray'             : QColor(105, 105, 105, ),
  'DodgerBlue'          : QColor(30, 144, 255, ),
  'FireBrick'           : QColor(178, 34, 34, ),
  'FloralWhite'         : QColor(255, 250, 240, ),
  'ForestGreen'         : QColor(34, 139, 34, ),
  'Fuchsia'             : QColor(255, 0, 255, ),
  'Gainsboro'           : QColor(220, 220, 220, ),
  'GhostWhite'          : QColor(248, 248, 255, ),
  'Gold'                : QColor(255, 215, 0, ),
  'GoldenRod'           : QColor(218, 165, 32, ),
  'Gray'                : QColor(128, 128, 128, ),
  'Green'               : QColor(0, 128, 0, ),
  'GreenYellow'         : QColor(173, 255, 47, ),
  'HoneyDew'            : QColor(240, 255, 240, ),
  'HotPink'             : QColor(255, 105, 180, ),
  'IndianRed'           : QColor(205, 92, 92, ),
  'Indigo'              : QColor(75, 0, 130, ),
  'Ivory'               : QColor(255, 255, 240, ),
  'Khaki'               : QColor(240, 230, 140, ),
  'Lavender'            : QColor(230, 230, 250, ),
  'LavenderBlush'       : QColor(255, 240, 245, ),
  'LawnGreen'           : QColor(124, 252, 0, ),
  'LemonChiffon'        : QColor(255, 250, 205, ),
  'LightBlue'           : QColor(173, 216, 230, ),
  'LightCoral'          : QColor(240, 128, 128, ),
  'LightCyan'           : QColor(224, 255, 255, ),
  'LightGoldenRodYellow': QColor(250, 250, 210, ),
  'LightGray'           : QColor(211, 211, 211, ),
  'LightGreen'          : QColor(144, 238, 144, ),
  'LightPink'           : QColor(255, 182, 193, ),
  'LightSalmon'         : QColor(255, 160, 122, ),
  'LightSeaGreen'       : QColor(32, 178, 170, ),
  'LightSkyBlue'        : QColor(135, 206, 250, ),
  'LightSlateGray'      : QColor(119, 136, 153, ),
  'LightSteelBlue'      : QColor(176, 224, 230, ),
  'LightYellow'         : QColor(255, 255, 224, ),
  'Lime'                : QColor(0, 255, 0, ),
  'LimeGreen'           : QColor(50, 205, 50, ),
  'Linen'               : QColor(250, 240, 230, ),
  'Magenta'             : QColor(255, 0, 255, ),
  'Maroon'              : QColor(128, 0, 0, ),
  'MediumAquaMarine'    : QColor(102, 205, 170, ),
  'MediumBlue'          : QColor(0, 0, 205, ),
  'MediumOrchid'        : QColor(186, 85, 211, ),
  'MediumPurple'        : QColor(147, 112, 219, ),
  'MediumSeaGreen'      : QColor(60, 179, 113, ),
  'MediumSlateBlue'     : QColor(123, 104, 238, ),
  'MediumSpringGreen'   : QColor(0, 250, 154, ),
  'MediumTurquoise'     : QColor(72, 209, 204, ),
  'MediumVioletRed'     : QColor(199, 21, 133, ),
  'MidnightBlue'        : QColor(25, 25, 112, ),
  'MintCream'           : QColor(245, 255, 250, ),
  'MistyRose'           : QColor(255, 228, 225, ),
  'Moccasin'            : QColor(255, 228, 181, ),
  'NavajoWhite'         : QColor(255, 222, 173, ),
  'Navy'                : QColor(0, 0, 128, ),
  'OldLace'             : QColor(253, 245, 230, ),
  'Olive'               : QColor(128, 128, 0, ),
  'OliveDrab'           : QColor(107, 142, 35, ),
  'Orange'              : QColor(255, 165, 0, ),
  'OrangeRed'           : QColor(255, 69, 0, ),
  'Orchid'              : QColor(218, 112, 214, ),
  'PaleGoldenRod'       : QColor(238, 232, 170, ),
  'PaleGreen'           : QColor(152, 251, 152, ),
  'PaleTurquoise'       : QColor(175, 238, 238, ),
  'PaleVioletRed'       : QColor(219, 112, 147, ),
  'PapayaWhip'          : QColor(255, 239, 213, ),
  'PeachPuff'           : QColor(255, 218, 185, ),
  'Peru'                : QColor(205, 133, 63, ),
  'Pink'                : QColor(255, 192, 203, ),
  'Plum'                : QColor(221, 160, 221, ),
  'PowderBlue'          : QColor(176, 224, 230, ),
  'Purple'              : QColor(128, 0, 128, ),
  'RebeccaPurple'       : QColor(102, 51, 153, ),
  'Red'                 : QColor(255, 0, 0, ),
  'RosyBrown'           : QColor(188, 143, 143, ),
  'RoyalBlue'           : QColor(65, 105, 225, ),
  'SaddleBrown'         : QColor(139, 69, 19, ),
  'Salmon'              : QColor(250, 128, 114, ),
  'SandyBrown'          : QColor(244, 164, 96, ),
  'SeaGreen'            : QColor(46, 139, 87, ),
  'SeaShell'            : QColor(255, 245, 238, ),
  'Sienna'              : QColor(160, 82, 45, ),
  'Silver'              : QColor(192, 192, 192, ),
  'SkyBlue'             : QColor(135, 206, 235, ),
  'SlateBlue'           : QColor(106, 90, 205, ),
  'SlateGray'           : QColor(112, 128, 144, ),
  'Snow'                : QColor(255, 250, 250, ),
  'SpringGreen'         : QColor(0, 255, 127, ),
  'SteelBlue'           : QColor(70, 130, 180, ),
  'Tan'                 : QColor(210, 180, 140, ),
  'Teal'                : QColor(0, 128, 128, ),
  'Thistle'             : QColor(216, 191, 216, ),
  'Tomato'              : QColor(255, 99, 71, ),
  'Turquoise'           : QColor(64, 224, 208, ),
  'Violet'              : QColor(238, 130, 238, ),
  'Wheat'               : QColor(245, 222, 179, ),
  'White'               : QColor(255, 255, 255, ),
  'WhiteSmoke'          : QColor(245, 245, 245, ),
  'Yellow'              : QColor(255, 255, 0, ),
  'YellowGreen'         : QColor(154, 205, 50, ),
}

__all__ = [
  'ColorSpace',
  'colorDict',
  'AliceBlue',
  'AntiqueWhite',
  'Aqua',
  'Aquamarine',
  'Azure',
  'Beige',
  'Bisque',
  'Black',
  'BlanchedAlmond',
  'Blue',
  'BlueViolet',
  'Brown',
  'BurlyWood',
  'CadetBlue',
  'Chartreuse',
  'Chocolate',
  'Coral',
  'CornflowerBlue',
  'Cornsilk',
  'Crimson',
  'Cyan',
  'DarkBlue',
  'DarkCyan',
  'DarkGoldenRod',
  'DarkGray',
  'DarkGreen',
  'DarkKhaki',
  'DarkMagenta',
  'DarkOliveGreen',
  'DarkOrange',
  'DarkOrchid',
  'DarkRed',
  'DarkSalmon',
  'DarkSeaGreen',
  'DarkSlateBlue',
  'DarkSlateGray',
  'DarkTurquoise',
  'DarkViolet',
  'DeepPink',
  'DeepSkyBlue',
  'DimGray',
  'DodgerBlue',
  'FireBrick',
  'FloralWhite',
  'ForestGreen',
  'Fuchsia',
  'Gainsboro',
  'GhostWhite',
  'Gold',
  'GoldenRod',
  'Gray',
  'Green',
  'GreenYellow',
  'HoneyDew',
  'HotPink',
  'IndianRed',
  'Indigo',
  'Ivory',
  'Khaki',
  'Lavender',
  'LavenderBlush',
  'LawnGreen',
  'LemonChiffon',
  'LightBlue',
  'LightCoral',
  'LightCyan',
  'LightGoldenRodYellow',
  'LightGray',
  'LightGreen',
  'LightPink',
  'LightSalmon',
  'LightSeaGreen',
  'LightSkyBlue',
  'LightSlateGray',
  'LightSteelBlue',
  'LightYellow',
  'Lime',
  'LimeGreen',
  'Linen',
  'Magenta',
  'Maroon',
  'MediumAquaMarine',
  'MediumBlue',
  'MediumOrchid',
  'MediumPurple',
  'MediumSeaGreen',
  'MediumSlateBlue',
  'MediumSpringGreen',
  'MediumTurquoise',
  'MediumVioletRed',
  'MidnightBlue',
  'MintCream',
  'MistyRose',
  'Moccasin',
  'NavajoWhite',
  'Navy',
  'OldLace',
  'Olive',
  'OliveDrab',
  'Orange',
  'OrangeRed',
  'Orchid',
  'PaleGoldenRod',
  'PaleGreen',
  'PaleTurquoise',
  'PaleVioletRed',
  'PapayaWhip',
  'PeachPuff',
  'Peru',
  'Pink',
  'Plum',
  'PowderBlue',
  'Purple',
  'RebeccaPurple',
  'Red',
  'RosyBrown',
  'RoyalBlue',
  'SaddleBrown',
  'Salmon',
  'SandyBrown',
  'SeaGreen',
  'SeaShell',
  'Sienna',
  'Silver',
  'SkyBlue',
  'SlateBlue',
  'SlateGray',
  'Snow',
  'SpringGreen',
  'SteelBlue',
  'Tan',
  'Teal',
  'Thistle',
  'Tomato',
  'Turquoise',
  'Violet',
  'Wheat',
  'White',
  'WhiteSmoke',
  'Yellow',
  'YellowGreen',
]
