"""Provides defaults settings in the Default class"""
#  MIT Licence
#  Copyright (c) 2024 Asger Jon Vistisen
from __future__ import annotations


class Default:
  """Provides defaults settings in the Default class"""

  anyTimer = 25
  paintTimer = 20
  noiseTimer = 10
  numPoints = 256

  sliderMin = 0
  sliderMax = 100
  sliderSingleStep = 1
  sliderPageStep = 10
  sliderTickInterval = 10

  numSliders = 8

  chartViewWidth = 400
  chartViewHeight = 300

  layoutPreference = 0  # 0: vertical, 1: horizontal

  bannerMargin = 32
  sliderHeight = 192
  sliderWidth = 32

  fontFamily = 'Montserrat'
