"""
Module: OCR_NOISE_DB.py

Purpose:
This module defines lists of known OCR noise patterns extracted from SEM image scale bars.
These patterns represent corrupted or misread digit-unit strings (e.g., "μπππ", "ππππ") that commonly occur
during automated text recognition. The lists are used to detect, filter, or correct noisy OCR outputs
within the pixel size extraction pipeline.

Contents:
- noisy_cases_for_1μπ: Patterns typically misread as "1 µm"
- noisy_cases_for_2μπ: Patterns typically misread as "2 µm"
- noisy_cases_for_10μ: Patterns typically misread as "10 µm"
- noisy_cases_for_20μπ: Patterns typically misread as "20 µm"
- noisy_cases_for_100μπ: Patterns typically misread as "100 µm"
- noisy_cases_for_1mm: Patterns typically misread as "1 mm"

- noisy_cases_for_nm: Patterns associated with nanometer-scale misreads
- all_noisy_cases: Combined list for general filtering

Usage:
Import these lists into your OCR or conversion modules to validate or clean digit-unit strings.

Example:
    from OCR_NOISE_DB import noisy_cases_for_1μπ
"""


# OCR noise patterns for 1μπ cases
noisy_cases_for_1μπ = [
        "90π5π107780ππ", "90π5π104281ππ", "90π5π129728ππ", "90π5π112929ππ",
        "424201πππ420474088π582", "25μ2014πππ424135988π", "1600ππ64ππππ5364", "1600ππ640ππππ6982",
        "1500π524ππππ4000", "1500π524ππππ52000", "900π5261ππππ4090", "900ππ660π1π5000",
        "75π5219π9848", "75π52ππ9660", "2000ππ64ππππ5000", "2000ππ642ππππ4056",
        "2000ππ642ππππ5909", "2000ππ644ππππ5000", "2000ππ642ππππ728", "2000ππ642ππππ2000",
        "2000ππ642ππππ5000", "2000ππ64ππππ2000", "2000ππ620π1π5000", "2000ππ63ππππ5000",
        "2000ππ63πππ5000", "2000π5239π52000", "2000π523πππ5000", "2000ππ639π52000",
        "2000ππ639ππ5000", "2000π5239ππ5000", "2000π523πππ52000", "2000ππ63ππππ2000",
        "2000ππ627ππππ5000", "172014μπ20147π1338488647π51", "172014μπ20147π1339518647π51",
        "500ππ639π1π52000", "500ππ63πππ3000", "500ππ667πππ5000", "500ππ667ππππ2000",
        "500π523ππππ2000", "500ππ63πππ5000", "500ππ63πππ2000", "500ππ639ππ5000",
        "500π523ππππ5000", "500π523π1π5000", "500π523πππ5000", "500π523π1π2000",
        "500ππ63ππππ2000", "500ππ63ππππ5000", "500ππ63ππππ3630", "500ππ63ππππ3706",
        "500ππ64ππππ5000", "1000π523ππππ6864", "1000ππ63ππππ6864", "1000ππ632ππ5000",
        "500ππ660π1π6176", "500ππ63π1π5000", "500ππ637ππππ2000", "500ππ637ππππ5000",
        "1000ππ632πππ4000", "1000ππ632πππ3000", "500ππ68ππ5000", "900ππ64πππ3216",
        "900ππ64ππππ4000", "900ππ64ππππ54726", "900ππ649ππππ6666", "900ππ648ππ8652",
        "900ππ660πππ56213", "900ππ649πππ5667", "1000ππ4ππ3207", "9086π52544ππ2667",
        "1000ππ44ππ1684", "1000ππ4ππ1651", "1000ππ4ππ3202", "1000ππ44ππ3246",
        "10μ2013ππ160250", "25μ2014ππ5π1422518234π", "2000ππ627πππ5067", "100π5228ππ52679",
        "2000ππ680π152041", "2000ππ627ππ1921", "100π210791ππ", "100π5π10791ππ","150π5248π8176"]
        
        

# OCR noise patterns for 2μπ cases
noisy_cases_for_2μπ = [
        "μ900ππ686π1π756", "μ900ππ681ππ", "μ900ππ674ππ70", "μ900ππ665π1π756",
        "μ900ππ636π1π751", "μπ75π5218π1π5724", "μπ75π52ππ1789", "μπ75π52201914",
        "μπ75π52ππ1651", "μπ75π5220π1π", "μπ75π522211π685", "μπ75π52ππ22326", 
        "μπ75π5218π1π65", "1720142μπ20147π133038748π51", "9720142μπ2047ππ133038748",
        "565μ2013053ππ12398308π51", "μ2000ππ680π1π4744", "μπ150π5244ππ71",
        "μπ150π5244ππ762", "μπ150π5244ππ5722", "μπ150π5244ππ175", "μπ150π5247ππ",
        "μπ150π5244ππ4", "μπ150π5244ππ713", "μπ150π5244ππ718", "μπ100π5247ππ178", 
        "μπ75π52201629"]


# OCR noise patterns for 10μ cases
noisy_cases_for_10μ = [
        "μ50πμπ", "μππμμ", "μππμ", "π", "ππ", "μ500ππ241π5125", "10190π216124ππ",
        "μ1980ππ46ππ115", "μ200ππ291π5124", "μ2000ππ81ππ1339", "101200π5π29ππ160",
        "90π5π10929ππ", "90π5π112382ππ", "10π90π5π142380ππ", "πππ580π1π129",
        "10190π5π16026ππ", "μ2000ππ2811π110", "140π8229ππ119", "140π82217ππ121",
        "μ20090", "90π5π12726ππ", "10π2008ππ14480ππ", "200π5π80ππ122", "100π52261π150",
        "2000ππ27ππ150", "100ππ27ππ150", "100ππ261π150", "μ900ππ44ππ154", "101600π5π28π160",
        "μ900ππ35π1π109", "μ500π5258π1π108", "μ2000ππ80π1π115", "μ2000ππ84π1π11",
        "500π5248ππ120", "μ500π52116π9359", "μ900ππ46ππ118", "μ900π5220π1π144",
        "μ500ππ46ππ11", "μ900π5243ππ130", "μ500ππ61ππ115", "μ900π5265π1π191",
        "μ900π5263π1π150", "μ900π5296π1π150", "μ900π5265π1π150", "μ900π5295π1π150",
        "μ900π5297ππ150", "μ900π5298ππ150", "μ500π5281ππ130", "μ1000ππ69π1π118",
        "μ900π5283π1π512", "μ200ππ82π1π5194", "900π5π1108ππ", "10π900π5π82ππ149",
        "1000ππ33π1π150", "1000ππ32π1π150", "μ500π5280π1π100", "μ500π5244ππ100",
        "μ500π5281ππ100", "400ππ46ππ150", "400π5246ππ150", "1010800π21608ππ",
        "1010800π216086ππ", "101π3821608ππ", "500π5232π1π150", "250π5233π1π150",
        "250ππ33π1π150", "101400π216060ππ", "μ500π5212ππ186", "μ500ππ120ππ186",
        "μ500π5287ππ150", "μ500ππ120ππ186", "1μπ900π8230π1π150", "500π522811π150",
        "500ππ2811π150", "μ900π5258π1π150", "μ2000ππ261π109", "μ500π5269π1π128",
        "200ππ40πππ139", "μ200ππ40πππ51232", "μ200ππ45π1π5132", "μ500ππ70ππ679",
        "μ500ππ69π1π106", "μ900π5281ππ152", "μ150ππ38π1π150", "μ200π52ππ100",
        "μ200π522ππ100", "μ900π52108ππ100", "μ500ππ74ππ5129", "μ200π5297ππ100",
        "μ200π52108ππ100", "900ππ44ππ150", "μ200π5246ππ150", "μ500ππ40πππ116",
        "μ2000ππ47ππ146", "μ900ππ54π1π150", "μ900ππ65π1π149", "μ200π5261ππ14",
        "μ500π5298ππ5194", "μ500π5298ππ128", "μ500π52231π11", "900π2111188π",
        "10π900π2144188ππ", "μ500ππ38π1π122", "μ500ππ38π1π4147", "μ500ππ38π1π111",
        "μ1000ππ45π1π5122", "μ200π5247ππ130", "500π5270ππ109", "μ500ππ70ππ979",
        "μ500ππ70ππ952", "μ900π52122πππ148", "π68", "μ100π5273π1π5123",
        "μ900π5244ππ150", "1μπ900π8239ππ150", "500ππ33π1π139", "μ400π5248ππ150",
        "μ500π5248ππ150", "μ500ππ61ππ150", "μ500ππ67π1π150", "1000ππ38π1π150",
        "μ500ππ63π1π150", "1μπ600π8219ππ150", "μ200π5243ππ150", "μ200π5233π1π150",
        "μ200π5248ππ150", "μ200π5242π1π150", "μ200π5284π1π150", "μ900ππ33π1π5125",
        "200π5287ππ150", "500ππ47ππ139", "μ500ππ48ππ109", "μ500ππ48ππ110",
        "μ200π5210ππ160", "μ200π52659π1π150", "μ200π5210ππ180", "μ200π5266π1π150",
        "μ200π5265π1π150", "μ200π5261ππ150", "μ200π5258π1π150", "μ200π5275π1π150",
        "μ200π5263π1π150", "900π5245π1π150", "μ900π5245π1π146", "800π5266π1π138",
        "μ800ππ66π1π109", "μ200π5238π1π5125", "μ1000π5258π1π5129", "μ1000π5258π1π151",
        "1000ππ67π1π140", "μ500ππ64π1π924", "μ500ππ49ππ120", "μ500ππ84π1π150",
        "μ900π5280π1π154", "μ500π5244ππ142", "μ500π5261ππ155", "μ100ππ61ππ142",
        "μ1000π5280π1π119", "1000π5280π1π141", "1750ππ2461π500", "μ500π5265π1π102",
        "μ500ππ126ππ129", "μ500π52182ππ100", "μ750ππ48ππ111", "500π52ππ5112",
        "500π5262π1π120", "900π52ππ5112", "211330π401π09705842", "1449211319001ππ114803572μ8",
        "μ2000π5284ππ51232", "1000ππ84π1π140", "μ1000ππ35π1π113", "μ900ππ58π1π150",
        "μ900ππ46ππ128"]


# OCR noise prefixes for 10μ  cases
prefixes_for_10μ = [
        "μ100ππ36π1π1", "2000ππ33π1π", "μ100π522811π1", "1000ππ4", "10100π5π68"]


# OCR noise patterns for 20μπ cases
noisy_cases_for_20μπ = [
        "20π550044πππ680", "20π80018πππ680", "μμ500π52155ππ719", "20π550058ππ32π603",
        "20000π82217ππ699", "μμ100ππ87ππ72", "μ900ππ44ππ670", "2090π5π69227ππ",
        "μμ2000ππ84π1π721", "μ500π5266π1π524", "900π52105π1π712", "μμ1000π5287ππ748",
        "μμ900π5284ππ662", "2μπ600π8266ππ728", "μμ150π5273π1π7359", "1000π52291π724",
        "900π5276π1π714", "0μ900π527ππ77", "0μ500ππ7ππ7", "0μ500ππ128π77",
        "μμ200ππ82π1π66", "1000π52157ππ710", "20π550028πππ680", "20π110μ04200281π18273272",
        "μμ2000ππ78π1π794", "μ200ππ64π1π6563", "500π5268π1π71", "μμ500π5269π1π662",
        "μμ500π5268π1π6563", "0μ800π5232π1π784", "0μ800ππ32π1π784", "μμ1000ππ65π1π718",
        "μμ200ππ48ππ729", "202008ππ6918ππ", "μ1000π5245π1π66", "μμ200ππ4ππ757",
        "μμ800ππ46ππ714", "500π5260ππ7356", "900π52251π7356", "100π5220π1π750",
        "μμ900ππ2811π660", "μμ900ππ291π748", "μμ900ππ2811π748", "μμ150ππ291π58",
        "100ππ81ππ4715", "0μ100π5235π1π784", "200π52291π708", "900π522811π729",
        "0μ100π52261π772", "μμ150π5246ππ750", "20π227ππ693", "20π1917μ203300281πππ1634375",
        "μμ500π5243ππ719", "20600π2702ππ", "0μ500π5298ππ778", "μ1000π52109ππ666",
        "200π5266π1π72", "μμ200π5266π1π669", "0μ500π5269π1π71", "0μ500π5269π1π8763",
        "μμ500π5269π1π753", "0μ1000π5269π1π71", "μμ500ππ88π1π750", "26μπ5004ππ6ππ792",
        "μμ500ππ20π1π580", "μμ900π52921π728", "μμμ90088ππ572π448", "μμ1000π36π1π752",
        "μμ1600π5267π1π566", "μμ1600π67π1π566", "200π5248ππ714", "μμ900π5262π1π750",
        "5000π524ππ5861", "μμ500ππ48ππ659", "μμ2000ππ84ππ64", "μμ150π52653π1π750",
        "μμ200π5261ππ750", "μμ200π52106ππ750", "20π55008ππππ2194", "μμ200ππ35π1π708",
        "μμ500ππ84π1π729", "μμ500π5288π1π590", "500ππ80π1π716", "μμ1000π5267π1π756",
        "0μ500ππ67ππ772", "μμ500ππ62π1π6563", "500ππ80π1π741", "0μ250ππ190ππ7",
        "μμ500ππ17ππ758", "μμ500π52127ππ578", "μμ900π52111ππ579", "μμ1000ππ62π1π570",
        "μ900ππ10π1π666", "20π80028π1π8π981", "μμ100ππ60ππ745", "μ500π52112π527",
        "500ππ98ππ794", "μμ500ππ84ππ564", "750ππ2811π716", "μμ500π5284π1π566",
        "μμ900ππ105π1π760", "μ1600π52121ππ529", "μμ1600π52118π571", "μ900π52111ππ524",
        "μμ700π52106ππ592", "μ900π52120π1π65393", "μμ700π5293ππ588", "μμ900π521251π57",
        "μμ900π521251π585", "1600ππ86π1π566", "μμ1600ππ86π1π596", "μμ2000π5285π1π524",
        "1000π5236π1π73585", "20π100π52541ππ785", "20π100ππ68597ππ721", "20π2001ππ68596π1π750",
        "μ500ππ38π1π526"]


# OCR noise patterns for 100μπ cases
noisy_cases_for_100μπ = [
        "10μπ3014ππ680πππ50", "10μπ5004ππ63πππ500", "10μπ5004ππ619ππ250", "10μπ5004ππ621ππππ500"
        "10μπ5004ππ690πππ500", "10μπ5004ππ62ππ250", "10μπ5004ππ619ππ500"]


# OCR noise patterns for 1mm cases
noisy_cases_for_1mm = [
        "ππ10562013386π62928485", "900ππ104ππ64", "500π52114ππ64", "1000π522351π42",
        "πππ582ππ87π508", "ππ1320145187π1211034", "ππ10912014200188ππ1854158", "ππ10912014200188ππ1888307",
        "ππ10912014200188ππ189433", "ππ280120135181ππ1824497", "ππ17201215174ππ18228275", "ππ13π20135187ππ1102227",
        "πππ5008ππ71π4878", "πππ00ππ71π4878", "πππ150ππ84π4878", "πππ150ππ87π447", "πππ10ππ87π447", "πππ108ππ87π447",
        "πππ1508ππ87π54548", "πππ1508ππ87π4983", "πππ1ππ84π4933", "ππμ12013518π602245", "ππμ12013518ππ603045",
        "πππ0ππ81π4973", "ππ2320135111ππ4384085", "ππ11201358π1742785", "ππ124μ20450088ππ17198045", "ππ23562013511π19393185",
        "ππ1320135186π0231285", "ππ27ππ20145117ππ1902165", "ππ14π20145117π12281485", "ππ14π20145117π122892885",
        "ππ14π20145117π121142985", "ππ14π20145117π12275185", "ππ18π2014511π1639885", "ππ18π2014511π163435885",
        "ππ3101201350010π848125", "ππ19820147008πππ184833", "200π52105π1π50", "600π82ππ856", "ππ100μ120143188ππ9355375",
        "ππ180μπ20143188π248", "ππ4μ2013500128ππ34100245", "900π521221π51", "900π52193ππ48", "ππ200958ππ",
        "πππ207πππ5", "πππ205πππ5", "500π52116π495", "500ππ144ππ48", "500π52117ππ495", "πππ200ππ87π2968",
        "πππ2002ππ84π6584810", "500π52123ππ46", "500ππ6921π49", "πππππ81π4803", "ππ90112013898054961ππ9297225"]


# Known corrupted substrings from noisy SEM image batches
known_corrupted_substrings= [
        "12014200μππ", "12014208μππ", "132014μππ", "182014208μππ", "223912014μππ", "2241201421μππ"]


# Known noisy prefixes from SEM OCR output
known_noisy_prefixes= [
        "182014μπ55ππ", "1800120114μπ55ππ", "12312014μπ", "172014μπ4ππ", "142014μπ", "9412014μπ55ππ2", "9412014μππ"]                      
