"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .achexception import ACHException, ACHExceptionTypedDict
from .achtransactionstatus import ACHTransactionStatus
from .debitholdperiod import DebitHoldPeriod
from .seccode import SECCode
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ACHTransactionDetailsTypedDict(TypedDict):
    r"""ACH specific details about the transaction."""

    status: ACHTransactionStatus
    r"""Status of a transaction within the ACH lifecycle."""
    trace_number: str
    return_: NotRequired[ACHExceptionTypedDict]
    correction: NotRequired[ACHExceptionTypedDict]
    company_entry_description: NotRequired[str]
    r"""An optional override of the default NACHA company entry description for a transfer."""
    originating_company_name: NotRequired[str]
    r"""An optional override of the default NACHA company name for a transfer."""
    sec_code: NotRequired[SECCode]
    r"""Code used to identify the ACH authorization method."""
    canceled_on: NotRequired[datetime]
    initiated_on: NotRequired[datetime]
    originated_on: NotRequired[datetime]
    corrected_on: NotRequired[datetime]
    returned_on: NotRequired[datetime]
    failed_on: NotRequired[datetime]
    completed_on: NotRequired[datetime]
    debit_hold_period: NotRequired[DebitHoldPeriod]
    r"""An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting."""


class ACHTransactionDetails(BaseModel):
    r"""ACH specific details about the transaction."""

    status: ACHTransactionStatus
    r"""Status of a transaction within the ACH lifecycle."""

    trace_number: Annotated[str, pydantic.Field(alias="traceNumber")]

    return_: Annotated[Optional[ACHException], pydantic.Field(alias="return")] = None

    correction: Optional[ACHException] = None

    company_entry_description: Annotated[
        Optional[str], pydantic.Field(alias="companyEntryDescription")
    ] = None
    r"""An optional override of the default NACHA company entry description for a transfer."""

    originating_company_name: Annotated[
        Optional[str], pydantic.Field(alias="originatingCompanyName")
    ] = None
    r"""An optional override of the default NACHA company name for a transfer."""

    sec_code: Annotated[Optional[SECCode], pydantic.Field(alias="secCode")] = None
    r"""Code used to identify the ACH authorization method."""

    canceled_on: Annotated[Optional[datetime], pydantic.Field(alias="canceledOn")] = (
        None
    )

    initiated_on: Annotated[Optional[datetime], pydantic.Field(alias="initiatedOn")] = (
        None
    )

    originated_on: Annotated[
        Optional[datetime], pydantic.Field(alias="originatedOn")
    ] = None

    corrected_on: Annotated[Optional[datetime], pydantic.Field(alias="correctedOn")] = (
        None
    )

    returned_on: Annotated[Optional[datetime], pydantic.Field(alias="returnedOn")] = (
        None
    )

    failed_on: Annotated[Optional[datetime], pydantic.Field(alias="failedOn")] = None

    completed_on: Annotated[Optional[datetime], pydantic.Field(alias="completedOn")] = (
        None
    )

    debit_hold_period: Annotated[
        Optional[DebitHoldPeriod], pydantic.Field(alias="debitHoldPeriod")
    ] = None
    r"""An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting."""
