"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardbrand import CardBrand
from .cardexpiration import CardExpiration, CardExpirationTypedDict
from .cardtype import CardType
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ApplePayResponseTypedDict(TypedDict):
    r"""Describes an Apple Pay token on a Moov account."""

    brand: CardBrand
    r"""The card brand."""
    card_type: CardType
    r"""The type of the card."""
    card_display_name: str
    r"""User-friendly name of the tokenized card returned by Apple.

    It usually contains the brand and the last four digits of the underlying card.
    There is no standard format.
    """
    fingerprint: str
    r"""Uniquely identifies a linked payment card or token.
    For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
    This field can be used to identify specific payment methods across multiple accounts on your platform.
    """
    expiration: CardExpirationTypedDict
    r"""The expiration date of the card or token."""
    dynamic_last_four: str
    r"""The last four digits of the Apple Pay token, which may differ from the tokenized card's last four digits."""
    issuer_country: NotRequired[str]
    r"""Country where the underlying card was issued."""


class ApplePayResponse(BaseModel):
    r"""Describes an Apple Pay token on a Moov account."""

    brand: CardBrand
    r"""The card brand."""

    card_type: Annotated[CardType, pydantic.Field(alias="cardType")]
    r"""The type of the card."""

    card_display_name: Annotated[str, pydantic.Field(alias="cardDisplayName")]
    r"""User-friendly name of the tokenized card returned by Apple.

    It usually contains the brand and the last four digits of the underlying card.
    There is no standard format.
    """

    fingerprint: str
    r"""Uniquely identifies a linked payment card or token.
    For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
    This field can be used to identify specific payment methods across multiple accounts on your platform.
    """

    expiration: CardExpiration
    r"""The expiration date of the card or token."""

    dynamic_last_four: Annotated[str, pydantic.Field(alias="dynamicLastFour")]
    r"""The last four digits of the Apple Pay token, which may differ from the tokenized card's last four digits."""

    issuer_country: Annotated[Optional[str], pydantic.Field(alias="issuerCountry")] = (
        None
    )
    r"""Country where the underlying card was issued."""
