"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .billingsummarydetails import BillingSummaryDetails, BillingSummaryDetailsTypedDict
from .billingsummaryinterchange import (
    BillingSummaryInterchange,
    BillingSummaryInterchangeTypedDict,
)
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CardAcquiringTypedDict(TypedDict):
    r"""A summary of card acquiring volume and fees."""

    volume_amount: NotRequired[AmountDecimalTypedDict]
    r"""The total transaction volume amount."""
    volume_count: NotRequired[int]
    r"""The total number of transactions."""
    fee_amount: NotRequired[AmountDecimalTypedDict]
    r"""The total fee amount."""
    interchange_fees: NotRequired[BillingSummaryInterchangeTypedDict]
    r"""A summary of interchange fees by card brand."""


class CardAcquiring(BaseModel):
    r"""A summary of card acquiring volume and fees."""

    volume_amount: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="volumeAmount")
    ] = None
    r"""The total transaction volume amount."""

    volume_count: Annotated[Optional[int], pydantic.Field(alias="volumeCount")] = None
    r"""The total number of transactions."""

    fee_amount: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="feeAmount")
    ] = None
    r"""The total fee amount."""

    interchange_fees: Annotated[
        Optional[BillingSummaryInterchange], pydantic.Field(alias="interchangeFees")
    ] = None
    r"""A summary of interchange fees by card brand."""


class BillingSummaryTypedDict(TypedDict):
    r"""A summary of all fees included in a statement."""

    card_acquiring: NotRequired[CardAcquiringTypedDict]
    r"""A summary of card acquiring volume and fees."""
    ach: NotRequired[BillingSummaryDetailsTypedDict]
    r"""A summary of ACH volume and fees."""
    instant_payments: NotRequired[BillingSummaryDetailsTypedDict]
    r"""A summary of instant payment volume and fees."""
    platform_fees: NotRequired[AmountDecimalTypedDict]
    r"""The total amount of platform fees."""
    adjustment_fees: NotRequired[AmountDecimalTypedDict]
    r"""The total amount of adjustment fees."""
    other_fees: NotRequired[AmountDecimalTypedDict]
    r"""The total amount of other fees."""
    total: NotRequired[AmountDecimalTypedDict]
    r"""The total amount of all fees."""


class BillingSummary(BaseModel):
    r"""A summary of all fees included in a statement."""

    card_acquiring: Annotated[
        Optional[CardAcquiring], pydantic.Field(alias="cardAcquiring")
    ] = None
    r"""A summary of card acquiring volume and fees."""

    ach: Optional[BillingSummaryDetails] = None
    r"""A summary of ACH volume and fees."""

    instant_payments: Annotated[
        Optional[BillingSummaryDetails], pydantic.Field(alias="instantPayments")
    ] = None
    r"""A summary of instant payment volume and fees."""

    platform_fees: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="platformFees")
    ] = None
    r"""The total amount of platform fees."""

    adjustment_fees: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="adjustmentFees")
    ] = None
    r"""The total amount of adjustment fees."""

    other_fees: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="otherFees")
    ] = None
    r"""The total amount of other fees."""

    total: Optional[AmountDecimal] = None
    r"""The total amount of all fees."""
