"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class BillingSummaryDetailsTypedDict(TypedDict):
    r"""Details of volume and fees for a specific payment method."""

    volume_amount: NotRequired[AmountDecimalTypedDict]
    r"""The total transaction volume amount."""
    volume_count: NotRequired[int]
    r"""The total number of transactions."""
    fee_amount: NotRequired[AmountDecimalTypedDict]
    r"""The total fee amount."""


class BillingSummaryDetails(BaseModel):
    r"""Details of volume and fees for a specific payment method."""

    volume_amount: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="volumeAmount")
    ] = None
    r"""The total transaction volume amount."""

    volume_count: Annotated[Optional[int], pydantic.Field(alias="volumeCount")] = None
    r"""The total number of transactions."""

    fee_amount: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="feeAmount")
    ] = None
    r"""The total fee amount."""
