"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .billingcountandamount import BillingCountAndAmount, BillingCountAndAmountTypedDict
from .billinginterchangeprogramfee import (
    BillingInterchangeProgramFee,
    BillingInterchangeProgramFeeTypedDict,
)
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CardBrandFeesTypedDict(TypedDict):
    r"""A detailed breakdown of fees for a specific card brand."""

    total: BillingCountAndAmountTypedDict
    r"""Total fees for this card brand."""
    interchange: NotRequired[BillingCountAndAmountTypedDict]
    r"""Details of interchange fees."""
    interchange_programs: NotRequired[List[BillingInterchangeProgramFeeTypedDict]]
    r"""A list of interchange program fees."""
    network_passthrough: NotRequired[BillingCountAndAmountTypedDict]
    r"""Details of network passthrough fees."""
    completed_domestic_online: NotRequired[BillingCountAndAmountTypedDict]
    r"""Details of completed domestic online transactions."""
    completed_domestic_in_person: NotRequired[BillingCountAndAmountTypedDict]
    r"""Details of completed domestic in-person transactions."""
    completed_international_online: NotRequired[BillingCountAndAmountTypedDict]
    r"""Details of completed international online transactions."""
    completed_international_in_person: NotRequired[BillingCountAndAmountTypedDict]
    r"""Details of completed international in-person transactions."""
    declines: NotRequired[BillingCountAndAmountTypedDict]
    r"""Details of declined transactions."""
    refunds: NotRequired[BillingCountAndAmountTypedDict]
    r"""Details of refunded transactions."""


class CardBrandFees(BaseModel):
    r"""A detailed breakdown of fees for a specific card brand."""

    total: BillingCountAndAmount
    r"""Total fees for this card brand."""

    interchange: Optional[BillingCountAndAmount] = None
    r"""Details of interchange fees."""

    interchange_programs: Annotated[
        Optional[List[BillingInterchangeProgramFee]],
        pydantic.Field(alias="interchangePrograms"),
    ] = None
    r"""A list of interchange program fees."""

    network_passthrough: Annotated[
        Optional[BillingCountAndAmount], pydantic.Field(alias="networkPassthrough")
    ] = None
    r"""Details of network passthrough fees."""

    completed_domestic_online: Annotated[
        Optional[BillingCountAndAmount], pydantic.Field(alias="completedDomesticOnline")
    ] = None
    r"""Details of completed domestic online transactions."""

    completed_domestic_in_person: Annotated[
        Optional[BillingCountAndAmount],
        pydantic.Field(alias="completedDomesticInPerson"),
    ] = None
    r"""Details of completed domestic in-person transactions."""

    completed_international_online: Annotated[
        Optional[BillingCountAndAmount],
        pydantic.Field(alias="completedInternationalOnline"),
    ] = None
    r"""Details of completed international online transactions."""

    completed_international_in_person: Annotated[
        Optional[BillingCountAndAmount],
        pydantic.Field(alias="completedInternationalInPerson"),
    ] = None
    r"""Details of completed international in-person transactions."""

    declines: Optional[BillingCountAndAmount] = None
    r"""Details of declined transactions."""

    refunds: Optional[BillingCountAndAmount] = None
    r"""Details of refunded transactions."""
