"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .debitholdperiod import DebitHoldPeriod
from .seccode import SECCode
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateTransferSourceACHTypedDict(TypedDict):
    company_entry_description: NotRequired[str]
    r"""An optional override of the default NACHA company entry description for a transfer."""
    originating_company_name: NotRequired[str]
    r"""An optional override of the default NACHA company name for a transfer."""
    debit_hold_period: NotRequired[DebitHoldPeriod]
    r"""An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting."""
    sec_code: NotRequired[SECCode]
    r"""Code used to identify the ACH authorization method."""


class CreateTransferSourceACH(BaseModel):
    company_entry_description: Annotated[
        Optional[str], pydantic.Field(alias="companyEntryDescription")
    ] = None
    r"""An optional override of the default NACHA company entry description for a transfer."""

    originating_company_name: Annotated[
        Optional[str], pydantic.Field(alias="originatingCompanyName")
    ] = None
    r"""An optional override of the default NACHA company name for a transfer."""

    debit_hold_period: Annotated[
        Optional[DebitHoldPeriod], pydantic.Field(alias="debitHoldPeriod")
    ] = None
    r"""An optional override of your default ACH hold period in banking days. The hold period must be longer than or equal to your default setting."""

    sec_code: Annotated[Optional[SECCode], pydantic.Field(alias="secCode")] = None
    r"""Code used to identify the ACH authorization method."""
