"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .evidencetype import EvidenceType
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DisputeEvidenceResponseTypedDict(TypedDict):
    evidence_id: str
    dispute_id: str
    evidence_type: EvidenceType
    created_on: datetime
    updated_on: datetime
    text: NotRequired[str]
    r"""For text evidence, the text submitted as evidence."""
    mime_type: NotRequired[str]
    r"""For file evidence, the MIME type of the file."""
    filename: NotRequired[str]
    r"""For file evidence, the name of the file."""
    size: NotRequired[int]
    r"""For file evidence, the size of the file."""
    submitted_on: NotRequired[datetime]
    r"""When the evidence was submitted for review."""


class DisputeEvidenceResponse(BaseModel):
    evidence_id: Annotated[str, pydantic.Field(alias="evidenceID")]

    dispute_id: Annotated[str, pydantic.Field(alias="disputeID")]

    evidence_type: Annotated[EvidenceType, pydantic.Field(alias="evidenceType")]

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    text: Optional[str] = None
    r"""For text evidence, the text submitted as evidence."""

    mime_type: Annotated[Optional[str], pydantic.Field(alias="mimeType")] = None
    r"""For file evidence, the MIME type of the file."""

    filename: Optional[str] = None
    r"""For file evidence, the name of the file."""

    size: Optional[int] = None
    r"""For file evidence, the size of the file."""

    submitted_on: Annotated[Optional[datetime], pydantic.Field(alias="submittedOn")] = (
        None
    )
    r"""When the evidence was submitted for review."""
