"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .evidencetype import EvidenceType
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class EvidenceUploadResponseTypedDict(TypedDict):
    r"""Details of a successfully uploaded evidence file."""

    evidence_id: str
    r"""The ID of the evidence."""
    dispute_id: str
    r"""The ID of the dispute the evidence is associated with."""
    filename: str
    r"""The name of the evidence file."""
    mime_type: str
    r"""The MIME type of the evidence file."""
    size: int
    r"""The size of the evidence file."""
    evidence_type: EvidenceType
    created_on: datetime
    r"""The date and time the evidence was uploaded."""


class EvidenceUploadResponse(BaseModel):
    r"""Details of a successfully uploaded evidence file."""

    evidence_id: Annotated[str, pydantic.Field(alias="evidenceID")]
    r"""The ID of the evidence."""

    dispute_id: Annotated[str, pydantic.Field(alias="disputeID")]
    r"""The ID of the dispute the evidence is associated with."""

    filename: str
    r"""The name of the evidence file."""

    mime_type: Annotated[str, pydantic.Field(alias="mimeType")]
    r"""The MIME type of the evidence file."""

    size: int
    r"""The size of the evidence file."""

    evidence_type: Annotated[EvidenceType, pydantic.Field(alias="evidenceType")]

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]
    r"""The date and time the evidence was uploaded."""
