"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .filepurpose import FilePurpose
import io
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata, MultipartFormMetadata
import pydantic
from typing import IO, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class FileUploadRequestMultiPartFileTypedDict(TypedDict):
    file_name: str
    content: Union[bytes, IO[bytes], io.BufferedReader]
    content_type: NotRequired[str]


class FileUploadRequestMultiPartFile(BaseModel):
    file_name: Annotated[
        str, pydantic.Field(alias="fileName"), FieldMetadata(multipart=True)
    ]

    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]

    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


class FileUploadRequestMultiPartTypedDict(TypedDict):
    r"""Request to upload a file for an account."""

    file: FileUploadRequestMultiPartFileTypedDict
    r"""The file to be added. Valid types are `csv`, `png`, `jpeg`, `pdf`."""
    file_purpose: FilePurpose
    r"""The file's purpose."""
    metadata: NotRequired[str]
    r"""Additional metadata to be stored with the file, formatted as a JSON string.

    Valid keys are `representative_id`, `comment`, `requirement_id`, `error_code`.
    """


class FileUploadRequestMultiPart(BaseModel):
    r"""Request to upload a file for an account."""

    file: Annotated[
        FileUploadRequestMultiPartFile,
        FieldMetadata(multipart=MultipartFormMetadata(file=True)),
    ]
    r"""The file to be added. Valid types are `csv`, `png`, `jpeg`, `pdf`."""

    file_purpose: Annotated[
        FilePurpose, pydantic.Field(alias="filePurpose"), FieldMetadata(multipart=True)
    ]
    r"""The file's purpose."""

    metadata: Annotated[Optional[str], FieldMetadata(multipart=True)] = None
    r"""Additional metadata to be stored with the file, formatted as a JSON string.

    Valid keys are `representative_id`, `comment`, `requirement_id`, `error_code`.
    """
