"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .billingcountandamount import BillingCountAndAmount, BillingCountAndAmountTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class InstantPaymentFeesTypedDict(TypedDict):
    r"""A detailed breakdown of instant payment fees."""

    rtp_credit_transaction: BillingCountAndAmountTypedDict
    r"""Fees for RTP credit transactions."""
    push_to_card_transaction: BillingCountAndAmountTypedDict
    r"""Fees for push-to-card transactions."""
    pull_from_card_transaction: BillingCountAndAmountTypedDict
    r"""Fees for pull-from-card transactions."""
    total: BillingCountAndAmountTypedDict
    r"""Total instant payment fees."""
    rtp_decline: NotRequired[BillingCountAndAmountTypedDict]
    r"""Fees for RTP declines."""
    push_to_card_decline: NotRequired[BillingCountAndAmountTypedDict]
    r"""Fees for push-to-card declines."""
    pull_from_card_decline: NotRequired[BillingCountAndAmountTypedDict]
    r"""Fees for pull-from-card declines."""
    pull_from_card_refund: NotRequired[BillingCountAndAmountTypedDict]
    r"""Fees for pull-from-card refunds."""


class InstantPaymentFees(BaseModel):
    r"""A detailed breakdown of instant payment fees."""

    rtp_credit_transaction: Annotated[
        BillingCountAndAmount, pydantic.Field(alias="rtpCreditTransaction")
    ]
    r"""Fees for RTP credit transactions."""

    push_to_card_transaction: Annotated[
        BillingCountAndAmount, pydantic.Field(alias="pushToCardTransaction")
    ]
    r"""Fees for push-to-card transactions."""

    pull_from_card_transaction: Annotated[
        BillingCountAndAmount, pydantic.Field(alias="pullFromCardTransaction")
    ]
    r"""Fees for pull-from-card transactions."""

    total: BillingCountAndAmount
    r"""Total instant payment fees."""

    rtp_decline: Annotated[
        Optional[BillingCountAndAmount], pydantic.Field(alias="rtpDecline")
    ] = None
    r"""Fees for RTP declines."""

    push_to_card_decline: Annotated[
        Optional[BillingCountAndAmount], pydantic.Field(alias="pushToCardDecline")
    ] = None
    r"""Fees for push-to-card declines."""

    pull_from_card_decline: Annotated[
        Optional[BillingCountAndAmount], pydantic.Field(alias="pullFromCardDecline")
    ] = None
    r"""Fees for pull-from-card declines."""

    pull_from_card_refund: Annotated[
        Optional[BillingCountAndAmount], pydantic.Field(alias="pullFromCardRefund")
    ] = None
    r"""Fees for pull-from-card refunds."""
