"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from moovio_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class Use(str, Enum):
    r"""The intended use of the key. 'sig' for signature, 'enc' for encryption."""

    SIG = "sig"
    ENC = "enc"


class JSONWebKeyTypedDict(TypedDict):
    r"""Describes an [RFC7517](https://datatracker.ietf.org/doc/html/rfc7517) web key."""

    kty: str
    r"""The cryptographic algorithm family used with the key (e.g., 'RSA', 'EC', 'oct')."""
    use: NotRequired[Use]
    r"""The intended use of the key. 'sig' for signature, 'enc' for encryption."""
    key_ops: NotRequired[List[str]]
    r"""The permitted operations for the key, e.g., 'sign', 'verify', 'encrypt', 'decrypt'."""
    alg: NotRequired[str]
    r"""The algorithm intended for use with the key, e.g., 'RS256' or 'ES256'."""
    kid: NotRequired[str]
    r"""A unique identifier for the key."""
    crv: NotRequired[str]
    r"""The curve for Elliptic Curve keys, e.g., 'P-256', 'P-384', or 'P-521'.

    This field is required when `kty` is 'EC'.
    """
    x: NotRequired[str]
    r"""The x coordinate for Elliptic Curve keys.

    This field is required when `kty` is 'EC'.
    """
    y: NotRequired[str]
    r"""The y coordinate for Elliptic Curve keys.

    This field is required when `kty` is 'EC'.
    """
    n: NotRequired[str]
    r"""The modulus value for RSA keys.

    This field is required when `kty` is 'RSA'.
    """
    e: NotRequired[str]
    r"""The exponent value for RSA keys.

    This field is required when `kty` is 'RSA'.
    """


class JSONWebKey(BaseModel):
    r"""Describes an [RFC7517](https://datatracker.ietf.org/doc/html/rfc7517) web key."""

    kty: str
    r"""The cryptographic algorithm family used with the key (e.g., 'RSA', 'EC', 'oct')."""

    use: Optional[Use] = None
    r"""The intended use of the key. 'sig' for signature, 'enc' for encryption."""

    key_ops: Optional[List[str]] = None
    r"""The permitted operations for the key, e.g., 'sign', 'verify', 'encrypt', 'decrypt'."""

    alg: Optional[str] = None
    r"""The algorithm intended for use with the key, e.g., 'RS256' or 'ES256'."""

    kid: Optional[str] = None
    r"""A unique identifier for the key."""

    crv: Optional[str] = None
    r"""The curve for Elliptic Curve keys, e.g., 'P-256', 'P-384', or 'P-521'.

    This field is required when `kty` is 'EC'.
    """

    x: Optional[str] = None
    r"""The x coordinate for Elliptic Curve keys.

    This field is required when `kty` is 'EC'.
    """

    y: Optional[str] = None
    r"""The y coordinate for Elliptic Curve keys.

    This field is required when `kty` is 'EC'.
    """

    n: Optional[str] = None
    r"""The modulus value for RSA keys.

    This field is required when `kty` is 'RSA'.
    """

    e: Optional[str] = None
    r"""The exponent value for RSA keys.

    This field is required when `kty` is 'RSA'.
    """
