"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ManualTermsOfServiceUpdateTypedDict(TypedDict):
    r"""Describes the acceptance of the Terms of Service. All data is required, and must be from the user."""

    accepted_date: NotRequired[datetime]
    r"""The date and time the terms of service were accepted."""
    accepted_ip: NotRequired[str]
    r"""The IP address from which the terms of service were accepted."""
    accepted_user_agent: NotRequired[str]
    r"""The user-agent of the user making the request."""
    accepted_domain: NotRequired[str]


class ManualTermsOfServiceUpdate(BaseModel):
    r"""Describes the acceptance of the Terms of Service. All data is required, and must be from the user."""

    accepted_date: Annotated[
        Optional[datetime], pydantic.Field(alias="acceptedDate")
    ] = None
    r"""The date and time the terms of service were accepted."""

    accepted_ip: Annotated[Optional[str], pydantic.Field(alias="acceptedIP")] = None
    r"""The IP address from which the terms of service were accepted."""

    accepted_user_agent: Annotated[
        Optional[str], pydantic.Field(alias="acceptedUserAgent")
    ] = None
    r"""The user-agent of the user making the request."""

    accepted_domain: Annotated[
        Optional[str], pydantic.Field(alias="acceptedDomain")
    ] = None
