"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mode import Mode
from .occurrencesresponse import OccurrencesResponse, OccurrencesResponseTypedDict
from .partialscheduleaccount import (
    PartialScheduleAccount,
    PartialScheduleAccountTypedDict,
)
from .recur import Recur, RecurTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ScheduleListResponseTypedDict(TypedDict):
    destination_account_id: str
    mode: Mode
    r"""The operating mode for an account."""
    owner_account_id: str
    partner_account_id: str
    schedule_id: str
    source_account_id: str
    created_on: datetime
    updated_on: datetime
    description: NotRequired[str]
    r"""Simple description to place on the transfer."""
    occurrences: NotRequired[List[OccurrencesResponseTypedDict]]
    recur: NotRequired[RecurTypedDict]
    r"""Defines configuration for recurring transfers."""
    disabled_on: NotRequired[datetime]
    source_account: NotRequired[PartialScheduleAccountTypedDict]
    destination_account: NotRequired[PartialScheduleAccountTypedDict]
    partner_account: NotRequired[PartialScheduleAccountTypedDict]


class ScheduleListResponse(BaseModel):
    destination_account_id: Annotated[str, pydantic.Field(alias="destinationAccountID")]

    mode: Mode
    r"""The operating mode for an account."""

    owner_account_id: Annotated[str, pydantic.Field(alias="ownerAccountID")]

    partner_account_id: Annotated[str, pydantic.Field(alias="partnerAccountID")]

    schedule_id: Annotated[str, pydantic.Field(alias="scheduleID")]

    source_account_id: Annotated[str, pydantic.Field(alias="sourceAccountID")]

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    description: Optional[str] = None
    r"""Simple description to place on the transfer."""

    occurrences: Optional[List[OccurrencesResponse]] = None

    recur: Optional[Recur] = None
    r"""Defines configuration for recurring transfers."""

    disabled_on: Annotated[Optional[datetime], pydantic.Field(alias="disabledOn")] = (
        None
    )

    source_account: Annotated[
        Optional[PartialScheduleAccount], pydantic.Field(alias="sourceAccount")
    ] = None

    destination_account: Annotated[
        Optional[PartialScheduleAccount], pydantic.Field(alias="destinationAccount")
    ] = None

    partner_account: Annotated[
        Optional[PartialScheduleAccount], pydantic.Field(alias="partnerAccount")
    ] = None
