"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .achfees import ACHFees, ACHFeesTypedDict
from .billingsummary import BillingSummary, BillingSummaryTypedDict
from .cardacquiringfees import CardAcquiringFees, CardAcquiringFeesTypedDict
from .instantpaymentfees import InstantPaymentFees, InstantPaymentFeesTypedDict
from .othercardfees import OtherCardFees, OtherCardFeesTypedDict
from .platformfees import PlatformFees, PlatformFeesTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class StatementTypedDict(TypedDict):
    r"""A billing statement for a Moov account."""

    statement_id: str
    r"""The unique identifier for the statement."""
    statement_name: str
    r"""The name of the statement."""
    file_name: str
    r"""The name of the statement file."""
    file_size: int
    r"""The size of the statement file in bytes."""
    billing_period_start_date_time: datetime
    r"""The start date and time of the billing period."""
    billing_period_end_date_time: datetime
    r"""The end date and time of the billing period."""
    subscription_i_ds: List[str]
    r"""List of subscription IDs associated with this statement."""
    summary: BillingSummaryTypedDict
    r"""A summary of all fees included in this statement."""
    created_on: datetime
    r"""The date and time the statement was created."""
    updated_on: datetime
    r"""The date and time the statement was last updated."""
    card_acquiring_fees: NotRequired[CardAcquiringFeesTypedDict]
    r"""A detailed breakdown of card acquiring fees."""
    ach_fees: NotRequired[ACHFeesTypedDict]
    r"""A detailed breakdown of ACH fees."""
    instant_payment_fees: NotRequired[InstantPaymentFeesTypedDict]
    r"""A detailed breakdown of instant payment fees."""
    platform_fees: NotRequired[PlatformFeesTypedDict]
    r"""A detailed breakdown of platform fees."""
    other_card_fees: NotRequired[OtherCardFeesTypedDict]
    r"""A detailed breakdown of other card-related fees."""


class Statement(BaseModel):
    r"""A billing statement for a Moov account."""

    statement_id: Annotated[str, pydantic.Field(alias="statementID")]
    r"""The unique identifier for the statement."""

    statement_name: Annotated[str, pydantic.Field(alias="statementName")]
    r"""The name of the statement."""

    file_name: Annotated[str, pydantic.Field(alias="fileName")]
    r"""The name of the statement file."""

    file_size: Annotated[int, pydantic.Field(alias="fileSize")]
    r"""The size of the statement file in bytes."""

    billing_period_start_date_time: Annotated[
        datetime, pydantic.Field(alias="billingPeriodStartDateTime")
    ]
    r"""The start date and time of the billing period."""

    billing_period_end_date_time: Annotated[
        datetime, pydantic.Field(alias="billingPeriodEndDateTime")
    ]
    r"""The end date and time of the billing period."""

    subscription_i_ds: Annotated[List[str], pydantic.Field(alias="subscriptionIDs")]
    r"""List of subscription IDs associated with this statement."""

    summary: BillingSummary
    r"""A summary of all fees included in this statement."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]
    r"""The date and time the statement was created."""

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]
    r"""The date and time the statement was last updated."""

    card_acquiring_fees: Annotated[
        Optional[CardAcquiringFees], pydantic.Field(alias="cardAcquiringFees")
    ] = None
    r"""A detailed breakdown of card acquiring fees."""

    ach_fees: Annotated[Optional[ACHFees], pydantic.Field(alias="achFees")] = None
    r"""A detailed breakdown of ACH fees."""

    instant_payment_fees: Annotated[
        Optional[InstantPaymentFees], pydantic.Field(alias="instantPaymentFees")
    ] = None
    r"""A detailed breakdown of instant payment fees."""

    platform_fees: Annotated[
        Optional[PlatformFees], pydantic.Field(alias="platformFees")
    ] = None
    r"""A detailed breakdown of platform fees."""

    other_card_fees: Annotated[
        Optional[OtherCardFees], pydantic.Field(alias="otherCardFees")
    ] = None
    r"""A detailed breakdown of other card-related fees."""
