"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .achtransactiondetails import ACHTransactionDetails, ACHTransactionDetailsTypedDict
from .applepayresponse import ApplePayResponse, ApplePayResponseTypedDict
from .cardtransactiondetails import (
    CardTransactionDetails,
    CardTransactionDetailsTypedDict,
)
from .paymentmethodsbankaccount import (
    PaymentMethodsBankAccount,
    PaymentMethodsBankAccountTypedDict,
)
from .paymentmethodscard import PaymentMethodsCard, PaymentMethodsCardTypedDict
from .paymentmethodswallet import PaymentMethodsWallet, PaymentMethodsWalletTypedDict
from .paymentmethodtype import PaymentMethodType
from .rtptransactiondetails import RTPTransactionDetails, RTPTransactionDetailsTypedDict
from .transferaccount import TransferAccount, TransferAccountTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TransferDestinationTypedDict(TypedDict):
    payment_method_id: str
    payment_method_type: PaymentMethodType
    r"""The payment method type that represents a payment rail and directionality"""
    account: TransferAccountTypedDict
    bank_account: NotRequired[PaymentMethodsBankAccountTypedDict]
    r"""A bank account as contained within a payment method."""
    wallet: NotRequired[PaymentMethodsWalletTypedDict]
    card: NotRequired[PaymentMethodsCardTypedDict]
    r"""A card as contained within a payment method."""
    ach_details: NotRequired[ACHTransactionDetailsTypedDict]
    r"""ACH specific details about the transaction."""
    apple_pay: NotRequired[ApplePayResponseTypedDict]
    r"""Describes an Apple Pay token on a Moov account."""
    card_details: NotRequired[CardTransactionDetailsTypedDict]
    r"""Card-specific details about the transaction."""
    rtp_details: NotRequired[RTPTransactionDetailsTypedDict]
    r"""RTP specific details about the transaction."""


class TransferDestination(BaseModel):
    payment_method_id: Annotated[str, pydantic.Field(alias="paymentMethodID")]

    payment_method_type: Annotated[
        PaymentMethodType, pydantic.Field(alias="paymentMethodType")
    ]
    r"""The payment method type that represents a payment rail and directionality"""

    account: TransferAccount

    bank_account: Annotated[
        Optional[PaymentMethodsBankAccount], pydantic.Field(alias="bankAccount")
    ] = None
    r"""A bank account as contained within a payment method."""

    wallet: Optional[PaymentMethodsWallet] = None

    card: Optional[PaymentMethodsCard] = None
    r"""A card as contained within a payment method."""

    ach_details: Annotated[
        Optional[ACHTransactionDetails], pydantic.Field(alias="achDetails")
    ] = None
    r"""ACH specific details about the transaction."""

    apple_pay: Annotated[
        Optional[ApplePayResponse], pydantic.Field(alias="applePay")
    ] = None
    r"""Describes an Apple Pay token on a Moov account."""

    card_details: Annotated[
        Optional[CardTransactionDetails], pydantic.Field(alias="cardDetails")
    ] = None
    r"""Card-specific details about the transaction."""

    rtp_details: Annotated[
        Optional[RTPTransactionDetails], pydantic.Field(alias="rtpDetails")
    ] = None
    r"""RTP specific details about the transaction."""
