"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class VolumeRangeTypedDict(TypedDict):
    r"""Defines the volume ranges for tiered pricing models."""

    from_value: int
    r"""Specifies the lower value of a tier for the fee."""
    flat_amount: AmountDecimalTypedDict
    r"""The flat amount for a whole tier of the fee."""
    per_unit_amount: AmountDecimalTypedDict
    r"""The unit price for a specific tier of the fee."""
    to_value: NotRequired[int]
    r"""Specifies the upper value of a tier for the fee."""


class VolumeRange(BaseModel):
    r"""Defines the volume ranges for tiered pricing models."""

    from_value: Annotated[int, pydantic.Field(alias="fromValue")]
    r"""Specifies the lower value of a tier for the fee."""

    flat_amount: Annotated[AmountDecimal, pydantic.Field(alias="flatAmount")]
    r"""The flat amount for a whole tier of the fee."""

    per_unit_amount: Annotated[AmountDecimal, pydantic.Field(alias="perUnitAmount")]
    r"""The unit price for a specific tier of the fee."""

    to_value: Annotated[Optional[int], pydantic.Field(alias="toValue")] = None
    r"""Specifies the upper value of a tier for the fee."""
