"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from moovio_sdk.models.errors import MoovError
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FileTypedDict(TypedDict):
    filename: NotRequired[str]
    mime_type: NotRequired[str]


class File(BaseModel):
    filename: Optional[str] = None

    mime_type: Annotated[Optional[str], pydantic.Field(alias="mimeType")] = None


class FileUploadValidationErrorData(BaseModel):
    evidence_type: Annotated[Optional[str], pydantic.Field(alias="evidenceType")] = None

    file: Optional[File] = None


@dataclass(unsafe_hash=True)
class FileUploadValidationError(MoovError):
    data: FileUploadValidationErrorData = field(hash=False)

    def __init__(
        self,
        data: FileUploadValidationErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
