"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from moovio_sdk.models.components import statement as components_statement
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListStatementsGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class ListStatementsGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="x-moov-version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "v2024.01.00"
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class ListStatementsRequestTypedDict(TypedDict):
    account_id: str
    billing_period_start_date_time: NotRequired[datetime]
    r"""Optional date-time which inclusively filters all statements where billing period is on or after this date-time."""
    billing_period_end_date_time: NotRequired[datetime]
    r"""Optional date-time which exclusively filters all statements where billing period is before this date-time."""
    skip: NotRequired[int]
    count: NotRequired[int]


class ListStatementsRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    billing_period_start_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="billingPeriodStartDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which inclusively filters all statements where billing period is on or after this date-time."""

    billing_period_end_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="billingPeriodEndDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which exclusively filters all statements where billing period is before this date-time."""

    skip: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    count: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None


class ListStatementsResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: List[components_statement.StatementTypedDict]


class ListStatementsResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: List[components_statement.Statement]
