"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from moovio_sdk.models.components import (
    wallettransaction as components_wallettransaction,
    wallettransactionsourcetype as components_wallettransactionsourcetype,
    wallettransactionstatus as components_wallettransactionstatus,
    wallettransactiontype as components_wallettransactiontype,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListWalletTransactionsGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class ListWalletTransactionsGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="x-moov-version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = "v2024.01.00"
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    """


class ListWalletTransactionsRequestTypedDict(TypedDict):
    account_id: str
    wallet_id: str
    skip: NotRequired[int]
    count: NotRequired[int]
    transaction_type: NotRequired[
        components_wallettransactiontype.WalletTransactionType
    ]
    r"""Optional parameter to filter by transaction type."""
    transaction_types: NotRequired[
        List[components_wallettransactiontype.WalletTransactionType]
    ]
    r"""Optional, comma-separated parameter to filter by transaction types."""
    source_type: NotRequired[
        components_wallettransactionsourcetype.WalletTransactionSourceType
    ]
    r"""Optional parameter to filter by source type (i.e. transfer, dispute, issuing-transaction)."""
    source_id: NotRequired[str]
    r"""Optional parameter to filter by source ID."""
    status: NotRequired[components_wallettransactionstatus.WalletTransactionStatus]
    r"""Optional parameter to filter by status (`pending` or `completed`)."""
    created_start_date_time: NotRequired[datetime]
    r"""Optional date-time which inclusively filters all transactions created after this date-time."""
    created_end_date_time: NotRequired[datetime]
    r"""Optional date-time which exclusively filters all transactions created before this date-time."""
    completed_start_date_time: NotRequired[datetime]
    r"""Optional date-time which inclusively filters all transactions completed after this date-time."""
    completed_end_date_time: NotRequired[datetime]
    r"""Optional date-time which exclusively filters all transactions completed before this date-time."""
    sweep_id: NotRequired[str]
    r"""Optional ID to filter for transactions accrued in a sweep."""


class ListWalletTransactionsRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    wallet_id: Annotated[
        str,
        pydantic.Field(alias="walletID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    skip: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    count: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    transaction_type: Annotated[
        Optional[components_wallettransactiontype.WalletTransactionType],
        pydantic.Field(alias="transactionType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional parameter to filter by transaction type."""

    transaction_types: Annotated[
        Optional[List[components_wallettransactiontype.WalletTransactionType]],
        pydantic.Field(alias="transactionTypes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional, comma-separated parameter to filter by transaction types."""

    source_type: Annotated[
        Optional[components_wallettransactionsourcetype.WalletTransactionSourceType],
        pydantic.Field(alias="sourceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional parameter to filter by source type (i.e. transfer, dispute, issuing-transaction)."""

    source_id: Annotated[
        Optional[str],
        pydantic.Field(alias="sourceID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional parameter to filter by source ID."""

    status: Annotated[
        Optional[components_wallettransactionstatus.WalletTransactionStatus],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional parameter to filter by status (`pending` or `completed`)."""

    created_start_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="createdStartDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which inclusively filters all transactions created after this date-time."""

    created_end_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="createdEndDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which exclusively filters all transactions created before this date-time."""

    completed_start_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="completedStartDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which inclusively filters all transactions completed after this date-time."""

    completed_end_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="completedEndDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which exclusively filters all transactions completed before this date-time."""

    sweep_id: Annotated[
        Optional[str],
        pydantic.Field(alias="sweepID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional ID to filter for transactions accrued in a sweep."""


class ListWalletTransactionsResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: List[components_wallettransaction.WalletTransactionTypedDict]


class ListWalletTransactionsResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: List[components_wallettransaction.WalletTransaction]
