# If you want to use mypy or pyright, you may have to ignore some errors, like below:

# mypy: disable-error-code="type-arg"

from typing import overload, List
import numpy as np

NumberType = (int, float, np.number)

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:BoxedTypes>    ####################
class BoxedBool:
    value: bool
    def __init__(self, v: bool = False) -> None:
        pass
    def __repr__(self) -> str:
        pass

####################    </generated_from:BoxedTypes>    ####################

####################    <generated_from:DaftLib.h>    ####################

# //////////////////////////////////////////////////////////////////
# Basic functions bindings
# //////////////////////////////////////////////////////////////////
# (Note: this comment will also be published in the python stubs,
# as a documentation for the users)

@overload
def add(a: int, b: int) -> int:
    """Simple add function (this will be the docstring)"""
    pass

@overload
def add(a: int, b: int, c: int) -> int:
    """And this is a separate docstring, for this overload"""
    pass

def sub(a: int, b: int) -> int:
    """This is also a docstring,
    on multiple lines
    """
    pass

# //////////////////////////////////////////////////////////////////
# Classes and structs bindings
# ////////////////////////////////////////////////////////////////

class Point:
    """A default constructor with named parameters will
    be automatically generated in python for structs
    """

    x: int = 0
    y: int = 0
    def __init__(self, x: int = 0, y: int = 0) -> None:
        """Auto-generated default constructor with named params"""
        pass

class Widget:
    """A class will publish only its public methods and members"""

    def __init__(self) -> None:
        pass
    def get_value(self) -> int:
        pass
    def set_value(self, v: int) -> None:
        pass

# //////////////////////////////////////////////////////////////////
# Exclude functions and/or parameters from the bindings
# ////////////////////////////////////////////////////////////////

def set_options(v: bool) -> None:
    """The parameter priv_param will be excluded from the generated bindings
    since it has a default value, and is excluded via the options.
    See inside tools/autogenerate_bindings.py:
       options.fn_params_exclude_names__regex = "^priv_"
    """
    pass

# //////////////////////////////////////////////////////////////////
# Override virtual methods in python
# ////////////////////////////////////////////////////////////////

class Animal:
    """The virtual method of this class can be overriden in python
    see
       options.class_override_virtual_methods_in_python__regex = "^Animal$"
    """

    def go(self, n_times: int) -> str:  # overridable (pure virtual)
        pass
    def __init__(self) -> None:
        """Autogenerated default constructor"""
        pass

# //////////////////////////////////////////////////////////////////
# Publish bindings for template functions
# ////////////////////////////////////////////////////////////////

#  ------------------------------------------------------------------------
#      <template specializations for function MaxValue>
def max_value_int(values: List[int]) -> int:
    """MaxValue will be published as max_value_int and max_value_float
    See inside tools/autogenerate_bindings.py:
       options.fn_template_options.add_specialization("^MaxValue$", ["int", "float"], add_suffix_to_function_name=True)
    """
    pass

def max_value_float(values: List[float]) -> float:
    """MaxValue will be published as max_value_int and max_value_float
    See inside tools/autogenerate_bindings.py:
       options.fn_template_options.add_specialization("^MaxValue$", ["int", "float"], add_suffix_to_function_name=True)
    """
    pass

#      </template specializations for function MaxValue>
#  ------------------------------------------------------------------------

#  ------------------------------------------------------------------------
#      <template specializations for function MinValue>
@overload
def min_value(values: List[int]) -> int:
    """MinValue will be published as min_value for both int and float
    See inside tools/autogenerate_bindings.py:
       options.fn_template_options.add_specialization("^MinValue$", ["int", "float"], add_suffix_to_function_name=False)
    """
    pass

@overload
def min_value(values: List[float]) -> float:
    """MinValue will be published as min_value for both int and float
    See inside tools/autogenerate_bindings.py:
       options.fn_template_options.add_specialization("^MinValue$", ["int", "float"], add_suffix_to_function_name=False)
    """
    pass

#      </template specializations for function MinValue>
#  ------------------------------------------------------------------------

# //////////////////////////////////////////////////////////////////
# Return values policy
# ////////////////////////////////////////////////////////////////

def get_widget_singleton() -> Widget:
    """Python should not free the memory of the reference returned by GetWidgetSingleton()
    so we will force the reference policy to be 'reference' instead of 'automatic'
    See
           options.fn_return_force_policy_reference_for_references__regex = "Singleton$"
    """
    pass

# //////////////////////////////////////////////////////////////////
# Boxed types
# ////////////////////////////////////////////////////////////////

def switch_bool_value(v: BoxedBool) -> None:
    """SwitchBoolValue is a C++ function that takes a bool parameter by reference and changes its value
    Since bool are immutable in python, we can to use a BoxedBool instead in python.
    See inside tools/autogenerate_bindings.py:
           options.fn_params_replace_modifiable_immutable_by_boxed__regex = "^SwitchBoolValue$"
    """
    pass

# //////////////////////////////////////////////////////////////////
# Published vectorized math functions and namespaces
# ////////////////////////////////////////////////////////////////

# <submodule math_functions>
class math_functions:  # Proxy class that introduces typings for the *submodule* math_functions
    pass  # (This corresponds to a C++ namespace. All method are static!)
    """ - This namespace will be published as a python module
     - All functions inside this namespace will be vectorizable
       (see https://pthom.github.io/litgen/litgen_book/05_05_00_functions.html#vectorize-functions)
       See inside tools/autogenerate_bindings.py:
            options.fn_namespace_vectorize__regex = "^DaftLib::MathFunctions$"
            options.fn_vectorize__regex = r".*"
    """
    @staticmethod
    @overload
    def log(x: float) -> float:
        pass
    @staticmethod
    @overload
    def log(x: np.ndarray) -> np.ndarray:
        pass
    @staticmethod
    @overload
    def deg_to_rad(x: float) -> float:
        pass
    @staticmethod
    @overload
    def deg_to_rad(x: np.ndarray) -> np.ndarray:
        pass

# </submodule math_functions>
####################    </generated_from:DaftLib.h>    ####################

# </litgen_stub>
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
