# change_lib_name.py

This tool enables you to change the name of the C++ library, the python package, and the pip package.

In this template repository, by default:
- the C++ library is called `DaftLib`
- the native python module generated by pybind11 is called `_daft_lib`
- the python module which is imported by users is called `daft_lib` (it imports and optionally adapts `_daft_lib`)
- the pip package that can optionally be published to PyPI is called `daft-lib` (as Pypi does not allow dashes in package names)

You can change these names by running `change_lib_name.py`. This tool is intended to be run only once, after cloning this template.

## Example session with `change_lib_name.py.py`

```
>> python tools/change_lib_name/change_lib_name.py

 python tools/change_lib_name/change_lib_name.py 

* Step 1: enter the name of the cpp library to bind (in this template, it is named "DaftLib"):
a project with this name will be placed inside src/cpp_libraries/ (you can later replace it with your own)


    Name of the cpp library to bind: MyLib        <--- enter the name of your C++ library here

Step 2: Name of the python module that will bind the cpp library (in this template, it is named "daft_lib")
Following the python conventions, module names are preferably snake_case (and cannot contain "-")
Note: two python modules will be created:
    - one with the name you give here (it is a python interface to the native module)
    - one with the name you give here, prefixed by "_" (it is the native module)
            
    Name of the python module (enter "d" for default, i.e. MyLib): my_lib <--- enter the name of your python module here

Step 3: enter the name of the python pip package package (in this template, it is named "daft-lib")
This name can be close to the name of the python package, but can't include "_" (i.e. underscore) sign
        
    Name of the pip package (enter "d" for default, i.e. my-lib): my-lib <--- enter the name of your pip package here

Please confirm you want to make the modifications (it cannot be undone). Type 'yes' to confirm:   <-- type 'yes' to confirm
```

After this, you will see various messages explaining what was changed.
Test that everything works by running `python tools/autogenerate_bindings.py` and `pip install -v .`, then commit.


