# litgen

```{admonition} What is litgen
:class: note
`litgen`, also known as _Literate Generator_, is an automatic python bindings generator for humans who like nice code and APIs.

It can be used to bind C++ libraries into _documented_ and _discoverable_ python modules using [pybind11](https://pybind11.readthedocs.io/en/stable/index.html) or [nanobind](https://nanobind.readthedocs.io/en/latest/).

It can also be used as C++ transformation and refactoring tool.

[Source code](https://github.com/pthom/litgen), [Documentation](https://pthom.github.io/litgen/), [PyPI](https://pypi.org/project/litgen/)
```

Although being relatively new (2022), litgen was battle tested on 20 different libraries totalling more than 100,000 lines of code, and it is the main driving force behind the python bindings for [Dear ImGui Bundle](https://github.com/pthom/imgui_bundle).

litgen puts a strong emphasis on emitting documented and discoverable code, thus providing a great experience for the final python user.

```{admonition} srcML
:class: tip
litgen is based on [srcML](https://www.srcml.org/), a multi-language parsing tool to convert source code into XML, with a developer centric approach: preprocessor statements are kept unprocessed, and all original text is preserved (including white space, comments and special characters).
```


```{admonition} Full pdf version of this book
:class: tip
View or download the [full pdf](https://pthom.github.io/litgen/litgen_book/litgen_book.pdf) for this manual.

You may feed it into a LLM such as ChatGPT, so that it can help you with litgen related questions.
```

## Documented bindings

As an intro, here is an example when using bindings generated by litgen inside a python Integrated Development Environment (IDE):

![IDE auto completion](images/ide_autocomplete.png)

_Example of auto-completion in an IDE: all bindings are discoverable_

![IDE params](images/ide_params.png)

_Parameters type are accurately reproduced, and the function documentation is accessible_

In the example above, the bindings were generated from the following C++ function signature:
```cpp
// Parameters stacks (current window)
IMGUI_API void          PushItemWidth(float item_width); // push width of items for common large "item+label" widgets. >0.0f: width in pixels, <0.0f align xx pixels to the right of window (so -FLT_MIN always align width to the right side).
```

And the generated code consists of two parts:

1. a python stub file, which contains the documentation and the function signatures, e.g.:
```python
# Parameters stacks (current window)
# IMGUI_API void          PushItemWidth(float item_width);        /* original C++ signature */
def push_item_width(item_width: float) -> None:
    """push width of items for common large "item+label" widgets. >0.0: width in pixels, <0.0 align xx pixels to the right of window (so -FLT_MIN always align width to the right side)."""
    pass
```

1. a C++ bindings file, which contains the actual bindings, e.g.:
```cpp
m.def("push_item_width",
    ImGui::PushItemWidth,
    py::arg("item_width"),
    "push width of items for common large \"item+label\" widgets. >0.0: width in pixels, <0.0 align xx pixels to the right of window (so -FLT_MIN always align width to the right side).");
```

## Examples

More complete examples can be found online inside the [Dear ImGui Bundle](https://github.com/pthom/imgui_bundle) repository, for example:

* [imgui.h](https://github.com/pthom/imgui/blob/imgui_bundle/imgui.h) header file that declares the API for [Dear ImGui](https://github.com/ocornut/imgui) in a documented way
* [imgui.piy](https://github.com/pthom/imgui_bundle/blob/main/bindings/imgui_bundle/imgui/__init__.pyi) the corresponding python stub file which exposes the bindings in a documented way

## Compatibility

Being based on [srcML](http://www.srcml.org), litgen is compatible with C++14: your code can of course make use of more recent features (C++17, C++20 and C++23), but the API that you want to expose to python must be C++14 compatible.

## License

The [litgen project](https://github.com/pthom/litgen) is published under the [GNU General Public License, version 3](https://raw.githubusercontent.com/pthom/litgen/main/LICENSE.txt).

Code generated by litgen is not subject to the GPL license, allowing you to use it freely in your projects without the obligations of GPLv3.

## Credits

Acknowledging the use of litgen in your project's documentation is a nice way to support the project and help others discover it.

litgen is based on [srcML](https://www.srcml.org/), a multi-language parsing tool that converts source code into XML with a developer-centric approach: preprocessor statements are kept unprocessed, and all original text is preserved (including whitespace, comments, and special characters). [srcML](https://www.srcml.org) is published under the [GNU General Public License, version 3](https://raw.githubusercontent.com/srcML/srcML/master/COPYING.txt).

## Keep in Touch

We’d love to hear about how you're using litgen! If you are using it, please consider [sharing your experience and insights](https://github.com/pthom/litgen/discussions/19).


## Contributing

Contributions and skilled contributors are welcome! See contributors oriented documentation inside [Build.md](https://github.com/pthom/litgen/blob/main/Build.md).


## Help the Project

If litgen has made a difference for you - especially in a commercial or research setting - please consider [making a donation](https://www.paypal.com/donate/?hosted_button_id=SHJ68RVDKURZA). Your support goes a long way toward keeping the project alive and growing. Any contribution, no matter the size, is greatly appreciated!


## Technical Support

C++ is notorious for being hard to parse. As a consequence, the author makes no guarantee that the generator will work on all kinds of C++ constructs.

**Open Source Support:** If you need assistance in an open-source context, please [open an issue](https://github.com/pthom/litgen/issues) in the repository.

**Professional Support:** For more in-depth help in a professional setting, feel free to reach out to the author via email for consulting inquiries.


<!--
[![](https://raw.githubusercontent.com/pthom/imgui_bundle/main/bindings/imgui_bundle/doc/doc_images/btn_donate.gif)](https://www.paypal.com/donate/?hosted_button_id=SHJ68RVDKURZA)
-->

-----

# Table of contents

```{tableofcontents}
```
