# Generate binding files for a library


## Overview of generated files

The folder [DasLib](https://github.com/pthom/litgen/blob/main/litgen-book/example_bindings/DasLib)
demonstrates which files are generated by litgen, and how to create and populate them.
It does *not* contain explanation about how to use the generated files, and build the bindings.

(Please refer to the "cmake helper" section of this manual for more info about how to build them)


**Folder content**
```
DasLib/
├── cpp_sources/
│         └── DasLib/                    # This is a sample library for which you
│             ├── DasLib.cpp             # want to generate bindings
│             ├── DasLib.h
│             ├── DasLib2.cpp
│             └── DasLib2.h
├── autogenerate_das_lib.py              # This is the script that will populate the folder generated_code/
│                                         # For demonstration purpose, it can either work with an amalgamated header,
│                                         # or it can generated bindings from the two header files
└── generated_code/
    ├── DasLib_amalgamation/
    │         └── amalgamation.h          # Optional amalgamation header file
    ├── DasLib_bindings/
    │         ├── pybind_DasLib.cpp      # This is the generated cpp bindings code
    │         └── glue_code_DasLib.h     # This is the generated cpp glue code
    └── DasLib_stubs/
        ├── das_lib.pyi                  # This is the generated python stubs code
        └── py.typed                      # This is an empty file that indicates that the python module is typed
```

### Markers in generated files:

The generated files contain markers that indicate which parts of the file are generated, and which parts are not.

`DasLib/generated_code/DasLib_bindings/pybind_DasLib.cpp`
```cpp
#include <pybind11/pybind11.h>

#include "DasLib/DasLib.h"
#include "glue_code_DasLib.h"

namespace py = pybind11;

void py_init_module_das_lib(py::module& m)
{
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    // Code will be generated here...
    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
```

`DasLib/generated_code/DasLib_bindings/glue_code_DasLib.h`
```cpp
#include <string>

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!
// Code will be generated here...
// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

```

`DasLib/generated_code/DasLib_stubs/das_lib.pyi`
```python
# type: ignore

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
# Code will be generated here...
# </litgen_stub>
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

```

### Generate the bindings for one file

See the [autogenerate_das_lib.py](https://github.com/pthom/litgen/blob/main/src/litgen/litgen-book/example_bindings/DasLib/autogenerate_das_lib.py) script for an example of how to generate the bindings.

Relevant extract:
```python
    litgen.write_generated_code_for_file(
        options,
        input_cpp_header_file=input_cpp_header,               # in this case we will use the amalgamation header
        output_cpp_pydef_file=output_cpp_pydef_file,
        output_stub_pyi_file=output_stub_pyi_file,
        output_cpp_glue_code_file=output_cpp_glue_code_file
    )

````

### Generate an amalgamation header

See the [autogenerate_das_lib.py](https://github.com/pthom/litgen/blob/main/src/litgen/litgen-book/example_bindings/DasLib/autogenerate_das_lib.py) script for an example of how to generate the bindings.

Relevant extract:

```python
from codemanip import amalgamated_header

def make_amalgamated_header():
    """Generates an amalgamated header file for DasLib in generated_code/DasLib_amalgamation/amalgamation.h"""
    options = amalgamated_header.AmalgamationOptions()

    options.base_dir = THIS_DIR + "/cpp_sources"
    options.local_includes_startwith = "DasLib/"
    options.include_subdirs = ["DasLib"]
    options.main_header_file = "DasLib.h"
    options.dst_amalgamated_header_file = THIS_DIR + "/generated_code/DasLib_amalgamation/amalgamation.h"

    amalgamated_header.write_amalgamate_header_file(options)
```

### Generate the bindings for a collection of files
See the [autogenerate_das_lib.py](https://github.com/pthom/litgen/blob/main/src/litgen/litgen-book/example_bindings/DasLib/autogenerate_das_lib.py) script for an example of how to generate the bindings.

Relevant extract:

```python
    header_files = [
        THIS_DIR + "/cpp_sources/DasLib/DasLib.h",
        THIS_DIR + "/cpp_sources/DasLib/DasLib_2.h",
    ]
    litgen.write_generated_code_for_files(
        options,
        input_cpp_header_files=header_files,
        output_cpp_pydef_file=output_cpp_pydef_file,
        output_stub_pyi_file=output_stub_pyi_file,
        output_cpp_glue_code_file=output_cpp_glue_code_file
    )
```
