# litgen integration tests

This folder contains a full suite of integration tests for litgen.
- It builds a native C++ library called "mylib"
- It builds a python binding library called "lg_mylib" (with a corresponding pip package name "lg-mylib")

You can install the "lg-mylib" pip package with:
```bash
pip install [-e] .
```

## List of tests and documentation

The different tests are available at [mylib/](mylib/include/mylib).

It is advised to read the different header files inside [mylib/](mylib/), since they are thoroughly
commented and can help understand litgen.


## Folder structure

This folder structure is based on [lg_skbuild_template](https://github.com/pthom/lg_skbuild_template)

Below is a summary of the structure:


```
litgen/src/litgen/integration_tests/
├── pyproject.toml                            # Pip configuration file
├── setup.py                                  # Pip configuration file
├── CMakeLists.txt                            # CMakeLists (used also by pip, via skbuild)
├── requirements-dev.txt
├── Readme.md                                 # this file
├── _skbuild/                                 # temp build directory when building via pip
├── autogenerate_mylib.py                     # This script will read headers in mylib/ and
│                                             # generate bindings using litgen inside:
│                                             #    - _pydef_nanobind/pybind_mylib.cpp (C++ publishing code)
│                                             #    - _pydef_pybind11/pybind_mylib.cpp (C++ publishing code)
│                                             #    - _stubs/lg_mylib/__init__.pyi (stubs)
│
├── _pydef_nanobind/
│         ├── module.cpp
│         └── pybind_mylib.cpp                # C++ code for nanobind bindings generated by litgen
├── _pydef_pybind11/
│         ├── module.cpp
│         └── pybind_mylib.cpp                # C++ code for pybind11 bindings generated by litgen
├── _stubs/
│         └── lg_mylib/
│             ├── __init__.py
│             ├── __init__.pyi                # Stubs generated by litgen
│             ├── binding.cfg                 # A config file that will contains either "pybind" or "nanobind",
│             │                               #   and determines which bindings are being used
│             ├── use.py                      # Calling python -m lg_mylib.use "nanobind|pybind" will write to binding.cfg
│             └── py.typed
├── litgen_cmake/
│         └── litgen_cmake.cmake              # lg_cmake_utils is a submodule that contains utilities
│                                             # that make it easier to write cmake code for Pip modules
│
├── mylib/                                    # mylib/: contains the C++ library that will be
│         │                                   #  wrapped in a python module
│         │
│         ├── mylib_main/                     # Library "main files"
│         │         ├── CMakeLists.txt
│         │         ├── api_marker.h
│         │         ├── mylib.cpp
│         │         └── mylib.h               # includes all headers from mylib
│         │
│         ├── basic_test.h                    # Some test code in C++ for wich bindings will be generated
│         ├── basic_test.h.pydef.cpp          # Auto-generated pybind11 bindings for this file
│         ├── basic_test.h.pyi                # Auto-generated stub file for this file
│         ├── basic_test.py                   # This is a python test that will check the bindings
│         │
│         ├── c_string_list_test.h            # Some test code in C++ for wich bindings will be generated
│         ├── c_string_list_test.h.pydef.cpp  # Auto-generated pybind11 bindings for this file
│         ├── c_string_list_test.h.pyi        # Auto-generated stub file for this file
│         ├── c_string_list_test.py           # This is a python test that will check the bindings
│         │
│         ├── c_style_array_test.h            # Etc. There are lots of other tests
│                                             # Each of this file is documented, and should
│                                             # help understand litgen better
│                                             # help understand litgen better
│
├── mylib_amalgamation/
│         └── mylib_amalgamation.h            # amalgamated header for mylib/
```

## How to develop, build and run the tests

### Integration tests vs unit tests

Unit tests (litgen/src/litgen/tests) will test the bindings code generation, but will not compile and test the bindings: they will compare the
generated code with a reference code (with a string comparison).

Integration tests (litgen/src/litgen/integration_tests) will compile the bindings and run them. They will test:
- that the generated code compiles to a binding library
- that the binding library can be imported in python
- that the generated bindings pass python tests

### Develop and debug integration tests

The script "src/litgen/validate_bindings_compilation/validate_bindings_compilation.py" contains a sandbox where you can:
- provide C++ sample code for which to generate bindings
- provide options for litgen
- provide python sample code that will test the generated bindings

This is a good place to develop and debug litgen, before running the full integration tests.


### Run the full integration tests

A justfile (see [just.systems](https://just.systems/)) is provided at the top of the repository (see [justfile](../../../justfile)).
It provides commands to help run the tests:

```bash
 just -l
Available recipes:
    build_integration_tests_nanobind # Builds the integration tests for nanobind
    build_integration_tests_pybind   # Builds the integration tests for pybind
    default                          # List all available commands
    integration_tests                # Runs all tests for pybind and nanobind (after building the integration tests)
    integration_tests_nanobind       # Runs all tests for nanobind, after building the integration tests
    integration_tests_pybind         # Runs all tests for pybind, after building the integration tests
    mypy                             # Runs mypy on the top level folder (see mypy.ini)
    pytest                           # Just runs pytest (requires that the integration tests have been built)
```
