#include <nanobind/nanobind.h>
#include <nanobind/trampoline.h>
#include <nanobind/stl/array.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/vector.h>
#include <nanobind/stl/optional.h>
#include <nanobind/stl/shared_ptr.h>
#include <nanobind/stl/unique_ptr.h>
#include <nanobind/stl/map.h>
#include <nanobind/stl/tuple.h>
#include <nanobind/ndarray.h>

#include "mylib/mylib_main/mylib.h"

namespace nb = nanobind;

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// <litgen_glue_code>  // Autogenerated code below! Do not edit!
struct BoxedBool
{
    bool value;
    BoxedBool(bool v = false) : value(v) {}
    std::string __repr__() const { return std::string("BoxedBool(") + std::to_string(value) + ")"; }
};
struct BoxedInt
{
    int value;
    BoxedInt(int v = 0) : value(v) {}
    std::string __repr__() const { return std::string("BoxedInt(") + std::to_string(value) + ")"; }
};
struct BoxedString
{
    std::string value;
    BoxedString(std::string v = "") : value(v) {}
    std::string __repr__() const { return std::string("BoxedString(") + value + ")"; }
};
struct BoxedUnsignedLong
{
    unsigned long value;
    BoxedUnsignedLong(unsigned long v = 0) : value(v) {}
    std::string __repr__() const { return std::string("BoxedUnsignedLong(") + std::to_string(value) + ")"; }
};

namespace Root { namespace Inner {
// helper type to enable overriding virtual methods in python
class MyVirtualClass_trampoline : public MyVirtualClass
{
public:
    NB_TRAMPOLINE(MyVirtualClass, 3);

    int foo_virtual_public_pure() const override
    {
        NB_OVERRIDE_PURE_NAME(
            "foo_virtual_public_pure", // function name (python)
            foo_virtual_public_pure // function name (c++)
        );
    }
    int foo_virtual_protected(int x) const override
    {
        NB_OVERRIDE_NAME(
            "foo_virtual_protected", // function name (python)
            foo_virtual_protected, // function name (c++)
            x // params
        );
    }
    std::string foo_virtual_protected_const_const(const std::string & name) const override
    {
        NB_OVERRIDE_NAME(
            "foo_virtual_protected_const_const", // function name (python)
            foo_virtual_protected_const_const, // function name (c++)
            name // params
        );
    }
};
} }  // namespace Inner  // namespace Root

namespace Root { namespace Inner {
// helper type to enable overriding virtual methods in python
class MyVirtualDerivate_trampoline : public MyVirtualDerivate
{
public:
    NB_TRAMPOLINE(MyVirtualDerivate, 4);

    int foo_virtual_public_pure() const override
    {
        NB_OVERRIDE_NAME(
            "foo_virtual_public_pure", // function name (python)
            foo_virtual_public_pure // function name (c++)
        );
    }
    int foo_derivate() override
    {
        NB_OVERRIDE_NAME(
            "foo_derivate", // function name (python)
            foo_derivate // function name (c++)
        );
    }
    int foo_virtual_protected(int x) const override
    {
        NB_OVERRIDE_NAME(
            "foo_virtual_protected", // function name (python)
            foo_virtual_protected, // function name (c++)
            x // params
        );
    }
    std::string foo_virtual_protected_const_const(const std::string & name) const override
    {
        NB_OVERRIDE_NAME(
            "foo_virtual_protected_const_const", // function name (python)
            foo_virtual_protected_const_const, // function name (c++)
            name // params
        );
    }
};
} }  // namespace Inner  // namespace Root

namespace Root { namespace Inner {
// helper type for exposing protected functions
class MyVirtualClass_publicist : public MyVirtualClass
{
public:
    using MyVirtualClass::foo_virtual_protected;
    using MyVirtualClass::foo_virtual_protected_const_const;
};
} }  // namespace Inner  // namespace Root

// </litgen_glue_code> // Autogenerated code end
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


void py_init_module_lg_mylib(nb::module_& m)
{
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:BoxedTypes>    ////////////////////
    auto pyClassBoxedBool =
        nb::class_<BoxedBool>
            (m, "BoxedBool", "")
        .def_rw("value", &BoxedBool::value, "")
        .def(nb::init<bool>(),
            nb::arg("v") = false)
        .def("__repr__",
            &BoxedBool::__repr__)
        ;


    auto pyClassBoxedInt =
        nb::class_<BoxedInt>
            (m, "BoxedInt", "")
        .def_rw("value", &BoxedInt::value, "")
        .def(nb::init<int>(),
            nb::arg("v") = 0)
        .def("__repr__",
            &BoxedInt::__repr__)
        ;


    auto pyClassBoxedString =
        nb::class_<BoxedString>
            (m, "BoxedString", "")
        .def_rw("value", &BoxedString::value, "")
        .def(nb::init<std::string>(),
            nb::arg("v") = "")
        .def("__repr__",
            &BoxedString::__repr__)
        ;


    auto pyClassBoxedUnsignedLong =
        nb::class_<BoxedUnsignedLong>
            (m, "BoxedUnsignedLong", "")
        .def_rw("value", &BoxedUnsignedLong::value, "")
        .def(nb::init<unsigned long>(),
            nb::arg("v") = 0)
        .def("__repr__",
            &BoxedUnsignedLong::__repr__)
        ;
    ////////////////////    </generated_from:BoxedTypes>    ////////////////////


    ////////////////////    <generated_from:mylib_amalgamation.h>    ////////////////////
    m.def("bindings_with_nanobind",
        bindings_with_nanobind);

    m.def("bindings_with_pybind",
        bindings_with_pybind);

    m.def("my_sub",
        my_sub,
        nb::arg("a"), nb::arg("b"),
        "Subtracts two numbers: this will be the function's __doc__ since my_sub does not have an end-of-line comment");

    m.def("my_add",
        my_add,
        nb::arg("a"), nb::arg("b"),
        "Adds two numbers");

    m.def("my_mul",
        my_mul, nb::arg("a"), nb::arg("b"));

    m.def("const_array2_add",
        [](const std::array<int, 2>& values) -> int
        {
            auto const_array2_add_adapt_fixed_size_c_arrays = [](const std::array<int, 2>& values) -> int
            {
                auto lambda_result = const_array2_add(values.data());
                return lambda_result;
            };

            return const_array2_add_adapt_fixed_size_c_arrays(values);
        },
        nb::arg("values"),
        " Tests with const array: since the input numbers are const, their params are published as List[int],\n and the python signature will be:\n -->    def add_c_array2(values: List[int]) -> int:\n (and the runtime will check that the list size is exactly 2)");

    m.def("array2_modify",
        [](BoxedUnsignedLong & values_0, BoxedUnsignedLong & values_1)
        {
            auto array2_modify_adapt_fixed_size_c_arrays = [](BoxedUnsignedLong & values_0, BoxedUnsignedLong & values_1)
            {
                unsigned long values_raw[2];
                values_raw[0] = values_0.value;
                values_raw[1] = values_1.value;

                array2_modify(values_raw);

                values_0.value = values_raw[0];
                values_1.value = values_raw[1];
            };

            array2_modify_adapt_fixed_size_c_arrays(values_0, values_1);
        },
        nb::arg("values_0"), nb::arg("values_1"),
        " Test with a modifiable array: since the input array is not const, it could be modified.\n Thus, it will be published as a function accepting Boxed values:\n -->    def array2_modify(values_0: BoxedUnsignedLong, values_1: BoxedUnsignedLong) -> None:");


    auto pyClassPoint2 =
        nb::class_<Point2>
            (m, "Point2", "")
        .def("__init__", [](Point2 * self, int x = int(), int y = int())
        {
            new (self) Point2();  // placement new
            auto r_ctor_ = self;
            r_ctor_->x = x;
            r_ctor_->y = y;
        },
        nb::arg("x") = int(), nb::arg("y") = int()
        )
        .def_rw("x", &Point2::x, "")
        .def_rw("y", &Point2::y, "")
        ;


    m.def("array2_modify_mutable",
        [](Point2 & out_0, Point2 & out_1)
        {
            auto array2_modify_mutable_adapt_fixed_size_c_arrays = [](Point2 & out_0, Point2 & out_1)
            {
                Point2 out_raw[2];
                out_raw[0] = out_0;
                out_raw[1] = out_1;

                array2_modify_mutable(out_raw);

                out_0 = out_raw[0];
                out_1 = out_raw[1];
            };

            array2_modify_mutable_adapt_fixed_size_c_arrays(out_0, out_1);
        },
        nb::arg("out_0"), nb::arg("out_1"),
        " Test with a modifiable array that uses a user defined struct.\n Since the user defined struct is mutable in python, it will not be Boxed,\n and the python signature will be:\n-->    def get_points(out_0: Point2, out_1: Point2) -> None:");

    m.def("add_inside_buffer",
        [](nb::ndarray<> & buffer, uint8_t number_to_add)
        {
            auto add_inside_buffer_adapt_c_buffers = [](nb::ndarray<> & buffer, uint8_t number_to_add)
            {
                // Check if the array is 1D and C-contiguous
                if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (mutable)
                void * buffer_from_pyarray = buffer.data();
                size_t buffer_count = buffer.shape(0);
                // Check the type of the ndarray (generic type and size)
                //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                uint8_t dtype_code_python_0 = buffer.dtype().code;
                uint8_t dtype_code_cpp_0 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                if (dtype_code_python_0 != dtype_code_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! While checking the generic type (dtype_code=UInt)!
                        )msg"));
                //   - Step 2: check the size of the type
                size_t size_python_0 = buffer.dtype().bits / 8;
                size_t size_cpp_0 = sizeof(uint8_t);
                if (size_python_0 != size_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! Size mismatch, while checking the size of the type (for param "buffer")!
                        )msg"));

                add_inside_buffer(static_cast<uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), number_to_add);
            };

            add_inside_buffer_adapt_c_buffers(buffer, number_to_add);
        },
        nb::arg("buffer"), nb::arg("number_to_add"),
        " add_inside_buffer: modifies a buffer by adding a value to its elements\n Will be published in python as:\n -->    def add_inside_buffer(buffer: np.ndarray, number_to_add: int) -> None:\n Warning, the python function will accept only uint8 numpy arrays, and check it at runtime!");

    m.def("buffer_sum",
        [](const nb::ndarray<> & buffer, int stride = -1) -> int
        {
            auto buffer_sum_adapt_c_buffers = [](const nb::ndarray<> & buffer, int stride = -1) -> int
            {
                // Check if the array is 1D and C-contiguous
                if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * buffer_from_pyarray = buffer.data();
                size_t buffer_count = buffer.shape(0);
                // Check the type of the ndarray (generic type and size)
                //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                uint8_t dtype_code_python_0 = buffer.dtype().code;
                uint8_t dtype_code_cpp_0 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                if (dtype_code_python_0 != dtype_code_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! While checking the generic type (dtype_code=UInt)!
                        )msg"));
                //   - Step 2: check the size of the type
                size_t size_python_0 = buffer.dtype().bits / 8;
                size_t size_cpp_0 = sizeof(uint8_t);
                if (size_python_0 != size_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! Size mismatch, while checking the size of the type (for param "buffer")!
                        )msg"));

                // process stride default value (which was a sizeof in C++)
                int buffer_stride = stride;
                if (buffer_stride == -1)
                    buffer_stride = (int)buffer.itemsize();

                auto lambda_result = buffer_sum(static_cast<const uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), static_cast<size_t>(buffer_stride));
                return lambda_result;
            };

            return buffer_sum_adapt_c_buffers(buffer, stride);
        },
        nb::arg("buffer"), nb::arg("stride") = -1,
        " buffer_sum: returns the sum of a *const* buffer\n Will be published in python as:\n -->    def buffer_sum(buffer: np.ndarray, stride: int = -1) -> int:");

    m.def("add_inside_two_buffers",
        [](nb::ndarray<> & buffer_1, nb::ndarray<> & buffer_2, uint8_t number_to_add)
        {
            auto add_inside_two_buffers_adapt_c_buffers = [](nb::ndarray<> & buffer_1, nb::ndarray<> & buffer_2, uint8_t number_to_add)
            {
                // Check if the array is 1D and C-contiguous
                if (! (buffer_1.ndim() == 1 && buffer_1.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (mutable)
                void * buffer_1_from_pyarray = buffer_1.data();
                size_t buffer_1_count = buffer_1.shape(0);
                // Check the type of the ndarray (generic type and size)
                //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                uint8_t dtype_code_python_0 = buffer_1.dtype().code;
                uint8_t dtype_code_cpp_0 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                if (dtype_code_python_0 != dtype_code_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! While checking the generic type (dtype_code=UInt)!
                        )msg"));
                //   - Step 2: check the size of the type
                size_t size_python_0 = buffer_1.dtype().bits / 8;
                size_t size_cpp_0 = sizeof(uint8_t);
                if (size_python_0 != size_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! Size mismatch, while checking the size of the type (for param "buffer_1")!
                        )msg"));

                // Check if the array is 1D and C-contiguous
                if (! (buffer_2.ndim() == 1 && buffer_2.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (mutable)
                void * buffer_2_from_pyarray = buffer_2.data();
                size_t buffer_2_count = buffer_2.shape(0);
                // Check the type of the ndarray (generic type and size)
                //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                uint8_t dtype_code_python_1 = buffer_2.dtype().code;
                uint8_t dtype_code_cpp_1 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                if (dtype_code_python_1 != dtype_code_cpp_1)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! While checking the generic type (dtype_code=UInt)!
                        )msg"));
                //   - Step 2: check the size of the type
                size_t size_python_1 = buffer_2.dtype().bits / 8;
                size_t size_cpp_1 = sizeof(uint8_t);
                if (size_python_1 != size_cpp_1)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! Size mismatch, while checking the size of the type (for param "buffer_2")!
                        )msg"));

                add_inside_two_buffers(static_cast<uint8_t *>(buffer_1_from_pyarray), static_cast<uint8_t *>(buffer_2_from_pyarray), static_cast<size_t>(buffer_2_count), number_to_add);
            };

            add_inside_two_buffers_adapt_c_buffers(buffer_1, buffer_2, number_to_add);
        },
        nb::arg("buffer_1"), nb::arg("buffer_2"), nb::arg("number_to_add"),
        " add_inside_two_buffers: modifies two mutable buffers\n litgen will detect that this function uses two buffers of same size.\n Will be published in python as:\n -->    def add_inside_two_buffers(buffer_1: np.ndarray, buffer_2: np.ndarray, number_to_add: int) -> None:");

    m.def("templated_mul_inside_buffer",
        [](nb::ndarray<> & buffer, double factor)
        {
            auto templated_mul_inside_buffer_adapt_c_buffers = [](nb::ndarray<> & buffer, double factor)
            {
                // Check if the array is 1D and C-contiguous
                if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (mutable)
                void * buffer_from_pyarray = buffer.data();
                size_t buffer_count = buffer.shape(0);

                using np_uint_l = uint64_t;
                using np_int_l = int64_t;

                // Define a lambda to compute the letter code for the buffer type
                auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                {
                    #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                        const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                            {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                            {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                            {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                        }};
                    #undef DCODE
                    for (const auto& [code_val, size, letter] : mappings)
                        if (code_val == dtype_code && size == sizeof_item)
                            return letter;
                    throw std::runtime_error("Unsupported dtype");
                };

                // Compute the letter code for the buffer type
                uint8_t dtype_code_buffer = buffer.dtype().code;
                size_t sizeof_item_buffer = buffer.dtype().bits / 8;
                char buffer_type = _nanobind_buffer_type_to_letter_code(dtype_code_buffer, sizeof_item_buffer);

                // call the correct template version by casting
                if (buffer_type == 'B')
                    templated_mul_inside_buffer(static_cast<uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'b')
                    templated_mul_inside_buffer(static_cast<int8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'H')
                    templated_mul_inside_buffer(static_cast<uint16_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'h')
                    templated_mul_inside_buffer(static_cast<int16_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'I')
                    templated_mul_inside_buffer(static_cast<uint32_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'i')
                    templated_mul_inside_buffer(static_cast<int32_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'L')
                    templated_mul_inside_buffer(static_cast<np_uint_l *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'l')
                    templated_mul_inside_buffer(static_cast<np_int_l *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'f')
                    templated_mul_inside_buffer(static_cast<float *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'd')
                    templated_mul_inside_buffer(static_cast<double *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'g')
                    templated_mul_inside_buffer(static_cast<long double *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'q')
                    templated_mul_inside_buffer(static_cast<long long *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                // If we reach this point, the array type is not supported!
                else
                    throw std::runtime_error(std::string("Bad array type ('") + buffer_type + "') for param buffer");
            };

            templated_mul_inside_buffer_adapt_c_buffers(buffer, factor);
        },
        nb::arg("buffer"), nb::arg("factor"),
        " templated_mul_inside_buffer: template function that modifies an array by multiplying its elements by a given factor\n litgen will detect that this function can be published as using a numpy array.\n It will be published in python as:\n -->    def mul_inside_buffer(buffer: np.ndarray, factor: float) -> None:\n\n The type will be detected at runtime and the correct template version will be called accordingly!\n An error will be thrown if the numpy array numeric type is not supported.");

    m.def("c_string_list_total_size",
        [](const std::vector<std::string> & items, BoxedInt & output_0, BoxedInt & output_1) -> size_t
        {
            auto c_string_list_total_size_adapt_fixed_size_c_arrays = [](const char * const items[], int items_count, BoxedInt & output_0, BoxedInt & output_1) -> size_t
            {
                int output_raw[2];
                output_raw[0] = output_0.value;
                output_raw[1] = output_1.value;

                auto lambda_result = c_string_list_total_size(items, items_count, output_raw);

                output_0.value = output_raw[0];
                output_1.value = output_raw[1];
                return lambda_result;
            };
            auto c_string_list_total_size_adapt_c_string_list = [&c_string_list_total_size_adapt_fixed_size_c_arrays](const std::vector<std::string> & items, BoxedInt & output_0, BoxedInt & output_1) -> size_t
            {
                std::vector<const char *> items_ptrs;
                items_ptrs.reserve(items.size());
                for (const auto& v: items)
                    items_ptrs.push_back(v.c_str());
                int items_count = static_cast<int>(items.size());

                auto lambda_result = c_string_list_total_size_adapt_fixed_size_c_arrays(items_ptrs.data(), items_count, output_0, output_1);
                return lambda_result;
            };

            return c_string_list_total_size_adapt_c_string_list(items, output_0, output_1);
        },
        nb::arg("items"), nb::arg("output_0"), nb::arg("output_1"),
        "\n C String lists tests:\n   Two consecutive params (const char *, int | size_t) are exported as List[str]\n\n The following function will be exported with the following python signature:\n -->    def c_string_list_total_size(items: List[str], output_0: BoxedInt, output_1: BoxedInt) -> int:\n");

    m.def("toggle_bool_pointer",
        [](BoxedBool & v)
        {
            auto ToggleBoolPointer_adapt_modifiable_immutable = [](BoxedBool & v)
            {
                bool * v_boxed_value = & (v.value);

                ToggleBoolPointer(v_boxed_value);
            };

            ToggleBoolPointer_adapt_modifiable_immutable(v);
        },
        nb::arg("v"),
        " Test with pointer:\n Will be published in python as:\n -->    def toggle_bool_pointer(v: BoxedBool) -> None:");

    m.def("toggle_bool_nullable",
        [](BoxedBool * v = nullptr)
        {
            auto ToggleBoolNullable_adapt_modifiable_immutable = [](BoxedBool * v = nullptr)
            {
                bool * v_boxed_value = nullptr;
                if (v != nullptr)
                    v_boxed_value = & (v->value);

                ToggleBoolNullable(v_boxed_value);
            };

            ToggleBoolNullable_adapt_modifiable_immutable(v);
        },
        nb::arg("v") = nb::none(),
        " Test with nullable pointer\n Will be published in python as:\n -->    def toggle_bool_nullable(v: BoxedBool = None) -> None:");

    m.def("toggle_bool_reference",
        [](BoxedBool & v)
        {
            auto ToggleBoolReference_adapt_modifiable_immutable = [](BoxedBool & v)
            {
                bool & v_boxed_value = v.value;

                ToggleBoolReference(v_boxed_value);
            };

            ToggleBoolReference_adapt_modifiable_immutable(v);
        },
        nb::arg("v"),
        " Test with reference\n Will be published in python as:\n -->    def toggle_bool_reference(v: BoxedBool) -> None:");

    m.def("modify_string",
        [](BoxedString & s)
        {
            auto ModifyString_adapt_modifiable_immutable = [](BoxedString & s)
            {
                std::string * s_boxed_value = & (s.value);

                ModifyString(s_boxed_value);
            };

            ModifyString_adapt_modifiable_immutable(s);
        },
        nb::arg("s"),
        " Test modifiable String\n Will be published in python as:\n -->    def modify_string(s: BoxedString) -> None:");

    m.def("change_bool_int",
        [](const char * label, int value) -> std::tuple<bool, int>
        {
            auto ChangeBoolInt_adapt_modifiable_immutable_to_return = [](const char * label, int value) -> std::tuple<bool, int>
            {
                int * value_adapt_modifiable = & value;

                bool r = ChangeBoolInt(label, value_adapt_modifiable);
                return std::make_tuple(r, value);
            };

            return ChangeBoolInt_adapt_modifiable_immutable_to_return(label, value);
        },
        nb::arg("label"), nb::arg("value"),
        " Test with int param + int return type\n Will be published in python as:\n --> def change_bool_int(label: str, value: int) -> Tuple[bool, int]:");

    m.def("change_void_int",
        [](const char * label, int value) -> int
        {
            auto ChangeVoidInt_adapt_modifiable_immutable_to_return = [](const char * label, int value) -> int
            {
                int * value_adapt_modifiable = & value;

                ChangeVoidInt(label, value_adapt_modifiable);
                return value;
            };

            return ChangeVoidInt_adapt_modifiable_immutable_to_return(label, value);
        },
        nb::arg("label"), nb::arg("value"),
        " Will be published in python as:\n -->    def change_void_int(label: str, value: int) -> int:");

    m.def("change_bool_int2",
        [](const char * label, int value1, int value2) -> std::tuple<bool, int, int>
        {
            auto ChangeBoolInt2_adapt_modifiable_immutable_to_return = [](const char * label, int value1, int value2) -> std::tuple<bool, int, int>
            {
                int * value1_adapt_modifiable = & value1;
                int * value2_adapt_modifiable = & value2;

                bool r = ChangeBoolInt2(label, value1_adapt_modifiable, value2_adapt_modifiable);
                return std::make_tuple(r, value1, value2);
            };

            return ChangeBoolInt2_adapt_modifiable_immutable_to_return(label, value1, value2);
        },
        nb::arg("label"), nb::arg("value1"), nb::arg("value2"),
        " Will be published in python as:\n -->    def change_bool_int2(label: str, value1: int, value2: int) -> Tuple[bool, int, int]:");

    m.def("change_void_int_default_null",
        [](const char * label, std::optional<int> value = std::nullopt) -> std::tuple<bool, std::optional<int>>
        {
            auto ChangeVoidIntDefaultNull_adapt_modifiable_immutable_to_return = [](const char * label, std::optional<int> value = std::nullopt) -> std::tuple<bool, std::optional<int>>
            {
                int * value_adapt_modifiable = nullptr;
                if (value.has_value())
                    value_adapt_modifiable = & (*value);

                bool r = ChangeVoidIntDefaultNull(label, value_adapt_modifiable);
                return std::make_tuple(r, value);
            };

            return ChangeVoidIntDefaultNull_adapt_modifiable_immutable_to_return(label, value);
        },
        nb::arg("label"), nb::arg("value").none() = nb::none(),
        " Will be published in python as:\n -->    def change_void_int_default_null(label: str, value: Optional[int] = None) -> Tuple[bool, Optional[int]]:");

    m.def("change_void_int_array",
        [](const char * label, std::array<int, 3> value) -> std::tuple<bool, std::array<int, 3>>
        {
            auto ChangeVoidIntArray_adapt_modifiable_immutable_to_return = [](const char * label, std::array<int, 3> value) -> std::tuple<bool, std::array<int, 3>>
            {
                int * value_adapt_modifiable = value.data();

                bool r = ChangeVoidIntArray(label, value_adapt_modifiable);
                return std::make_tuple(r, value);
            };

            return ChangeVoidIntArray_adapt_modifiable_immutable_to_return(label, value);
        },
        nb::arg("label"), nb::arg("value"),
        " Will be published in python as:\n -->    def change_void_int_array(label: str, value: List[int]) -> Tuple[bool, List[int]]:");

    m.def("add_overload",
        nb::overload_cast<int, int>(add_overload), nb::arg("a"), nb::arg("b"));

    m.def("add_overload",
        nb::overload_cast<int, int, int>(add_overload), nb::arg("a"), nb::arg("b"), nb::arg("c"));


    auto pyClassFooOverload =
        nb::class_<FooOverload>
            (m, "FooOverload", "")
        .def(nb::init<>()) // implicit default constructor
        .def("add_overload",
            nb::overload_cast<int, int>(&FooOverload::add_overload), nb::arg("a"), nb::arg("b"))
        .def("add_overload",
            nb::overload_cast<int, int, int>(&FooOverload::add_overload), nb::arg("a"), nb::arg("b"), nb::arg("c"))
        ;


    auto pyEnumBasicEnum =
        nb::enum_<BasicEnum>(m, "BasicEnum", nb::is_arithmetic(), "BasicEnum: a simple C-style enum")
            .value("a", BasicEnum_a, "This will be exported as BasicEnum.a")
            .value("aa", BasicEnum_aa, "This will be exported as BasicEnum.aa")
            .value("aaa", BasicEnum_aaa, "This will be exported as BasicEnum.aaa")
            .value("b", BasicEnum_b, "This is value b");


    auto pyEnumClassEnum =
        nb::enum_<ClassEnum>(m, "ClassEnum", nb::is_arithmetic(), "ClassEnum: a class enum that should be published")
            .value("on", ClassEnum::On, "")
            .value("off", ClassEnum::Off, "")
            .value("unknown", ClassEnum::Unknown, "");


    auto pyClassMyClass =
        nb::class_<MyClass>
            (m, "MyClass", "This is the class doc. It will be published as MyClass.__doc__")
        .def(nb::init<int, const std::string &>(),
            nb::arg("factor") = 10, nb::arg("message") = "hello")
        .def_rw("factor", &MyClass::factor, "")
        .def_rw("delta", &MyClass::delta, "")
        .def_rw("message", &MyClass::message, "")
        .def_rw("numbers", &MyClass::numbers, " By default, modifications from python are not propagated to C++ for stl containers\n (see https://pybind11.readthedocs.io/en/stable/advanced/cast/stl.html)")
        .def("append_number_from_cpp",
            &MyClass::append_number_from_cpp,
            nb::arg("v"),
            "However you can call dedicated modifying methods")
        .def_prop_ro("values",
            [](MyClass &self) -> nb::ndarray<int, nb::numpy, nb::shape<2>, nb::c_contig>
            {
                return self.values;
            },
            "")
        .def_prop_ro("flags",
            [](MyClass &self) -> nb::ndarray<bool, nb::numpy, nb::shape<3>, nb::c_contig>
            {
                return self.flags;
            },
            "")
        .def_ro_static("const_static_value", &MyClass::const_static_value, "")
        .def_rw_static("static_value", &MyClass::static_value, "")
        .def("calc",
            &MyClass::calc,
            nb::arg("x"),
            "calc: example of simple method")
        .def("set_message",
            &MyClass::set_message,
            nb::arg("m"),
            "set_message: another example of simple method")
        .def_static("static_message",
            &MyClass::static_message, "Returns a static message")
        ;


    auto pyClassMySingletonClass =
        nb::class_<MySingletonClass>
            (m, "MySingletonClass", " MySingletonClass: demonstrate how to instantiate a singleton\n - The instance method shall return with return_value_policy::reference\n - The destructor may be private")
        .def_rw("value", &MySingletonClass::value, "")
        .def(nb::init<>())
        .def_static("instance",
            &MySingletonClass::instance,
            "see: options.fn_return_force_policy_reference_for_references__regex = r\"instance\"",
            nb::rv_policy::reference)
        ;


    auto pyClassMyFinalClass =
        nb::class_<MyFinalClass>
            (m, "MyFinalClass", nb::is_final(), " This struct is final, and thus cannot be inherited from python\n(final class)")
        .def(nb::init<>()) // implicit default constructor
        .def("foo",
            &MyFinalClass::foo)
        ;


    auto pyClassMyStructDynamic =
        nb::class_<MyStructDynamic>
            (m, "MyStructDynamic", nb::dynamic_attr(), " This class accepts dynamic attributes\n see autogenerate_mylib.py:\n     options.class_dynamic_attributes__regex = r\"Dynamic$\"")
        .def("__init__", [](MyStructDynamic * self, int cpp_member = 1)
        {
            new (self) MyStructDynamic();  // placement new
            auto r_ctor_ = self;
            r_ctor_->cpp_member = cpp_member;
        },
        nb::arg("cpp_member") = 1
        )
        .def_rw("cpp_member", &MyStructDynamic::cpp_member, "")
        ;


    auto pyClassMyStructWithNestedEnum =
        nb::class_<MyStructWithNestedEnum>
            (m, "MyStructWithNestedEnum", "");

    { // inner classes & enums of MyStructWithNestedEnum
        auto pyEnumChoice =
            nb::enum_<MyStructWithNestedEnum::Choice>(pyClassMyStructWithNestedEnum, "Choice", nb::is_arithmetic(), "")
                .value("a", MyStructWithNestedEnum::Choice::A, "");
    } // end of inner classes & enums of MyStructWithNestedEnum

    pyClassMyStructWithNestedEnum
        .def(nb::init<>()) // implicit default constructor
        .def("handle_choice",
            &MyStructWithNestedEnum::HandleChoice,
            nb::arg("value") = MyStructWithNestedEnum::Choice::A,
            " The first param of this function uses the inner scope of this class!\n When building the bindings, we need to add MyStructWithNestedEnum::")
        ;


    auto pyClassClassWithInlineForwardDeclaredMethod =
        nb::class_<ClassWithInlineForwardDeclaredMethod>
            (m, "ClassWithInlineForwardDeclaredMethod", "")
        .def(nb::init<>()) // implicit default constructor
        .def("get_tex_id",
            &ClassWithInlineForwardDeclaredMethod::GetTexID)
        ;


    m.def("binding_multiple_inheritance",
        binding_multiple_inheritance);

    m.def("make_dog",
        make_dog, "Test that downcasting works: the return type is Animal, but it should bark!");


    auto pyClassColor4 =
        nb::class_<Color4>
            (m, "Color4", "")
        .def("__init__",
            [](Color4 * self, const std::array<uint8_t, 4>& _rgba)
            {
                auto ctor_wrapper = [](Color4* self, const uint8_t _rgba[4]) ->  void
                {
                    new(self) Color4(_rgba); // placement new
                };
                auto ctor_wrapper_adapt_fixed_size_c_arrays = [&ctor_wrapper](Color4 * self, const std::array<uint8_t, 4>& _rgba)
                {
                    ctor_wrapper(self, _rgba.data());
                };

                ctor_wrapper_adapt_fixed_size_c_arrays(self, _rgba);
            },
            nb::arg("_rgba"),
            "The constructor params will automatically be \"adapted\" into std::array<uint8_t, 4>")
        .def_prop_ro("rgba",
            [](Color4 &self) -> nb::ndarray<uint8_t, nb::numpy, nb::shape<4>, nb::c_contig>
            {
                return self.rgba;
            },
            "This member will be stored as a modifiable numpy array")
        ;


    auto pyClassCopyable_ImplicitCopyCtor =
        nb::class_<Copyable_ImplicitCopyCtor>
            (m, "Copyable_ImplicitCopyCtor", "")
        .def("__init__", [](Copyable_ImplicitCopyCtor * self, int a = 1)
        {
            new (self) Copyable_ImplicitCopyCtor();  // placement new
            auto r_ctor_ = self;
            r_ctor_->a = a;
        },
        nb::arg("a") = 1
        )
        .def_rw("a", &Copyable_ImplicitCopyCtor::a, "")
        .def("__copy__",  [](const Copyable_ImplicitCopyCtor &self) {
            return Copyable_ImplicitCopyCtor(self);
        })
        .def("__deepcopy__",  [](const Copyable_ImplicitCopyCtor &self, nb::dict) {
            return Copyable_ImplicitCopyCtor(self);
        }, nb::arg("memo"))    ;


    auto pyClassCopyable_ExplicitCopyCtor =
        nb::class_<Copyable_ExplicitCopyCtor>
            (m, "Copyable_ExplicitCopyCtor", "")
        .def(nb::init<>())
        .def(nb::init<const Copyable_ExplicitCopyCtor &>(),
            nb::arg("other"))
        .def_rw("a", &Copyable_ExplicitCopyCtor::a, "")
        .def("__copy__",  [](const Copyable_ExplicitCopyCtor &self) {
            return Copyable_ExplicitCopyCtor(self);
        })
        .def("__deepcopy__",  [](const Copyable_ExplicitCopyCtor &self, nb::dict) {
            return Copyable_ExplicitCopyCtor(self);
        }, nb::arg("memo"))    ;


    auto pyClassCopyable_ExplicitPrivateCopyCtor =
        nb::class_<Copyable_ExplicitPrivateCopyCtor>
            (m, "Copyable_ExplicitPrivateCopyCtor", "")
        .def(nb::init<>())
        .def_rw("a", &Copyable_ExplicitPrivateCopyCtor::a, "")
        ;


    auto pyClassCopyable_DeletedCopyCtor =
        nb::class_<Copyable_DeletedCopyCtor>
            (m, "Copyable_DeletedCopyCtor", "")
        .def_rw("a", &Copyable_DeletedCopyCtor::a, "")
        .def(nb::init<>())
        ;


    auto pyClassMyConfig =
        nb::class_<MyConfig>
            (m, "MyConfig", "")
        .def("__init__", [](MyConfig * self, int value = 0)
        {
            new (self) MyConfig();  // placement new
            auto r_ctor_ = self;
            r_ctor_->value = value;
        },
        nb::arg("value") = 0
        )
        .def_static("instance",
            &MyConfig::Instance,
            "// return_value_policy::reference",
            nb::rv_policy::reference)
        .def_rw("value", &MyConfig::value, "")
        ;


    m.def("my_config_instance",
        MyConfigInstance,
        "return_value_policy::reference",
        nb::rv_policy::reference);

    m.def("foo_root",
        FooRoot);


    auto pyClassIntWrapper =
        nb::class_<IntWrapper>
            (m, "IntWrapper", "")
        .def_rw("value", &IntWrapper::value, "")
        .def(nb::init<int>(),
            nb::arg("v"))
        .def("__add__",
            &IntWrapper::operator+, nb::arg("b"))
        .def("__sub__",
            nb::overload_cast<IntWrapper>(&IntWrapper::operator-), nb::arg("b"))
        .def("__neg__",
            [](IntWrapper & self) { return self.operator-(); }, "Unary minus operator")
        .def("__lt__",
            &IntWrapper::operator<,
            nb::arg("b"),
            "Comparison operator")
        .def("__iadd__",
            nb::overload_cast<IntWrapper>(&IntWrapper::operator+=), nb::arg("b"))
        .def("__iadd__",
            nb::overload_cast<int>(&IntWrapper::operator+=), nb::arg("b"))
        .def("__call__",
            nb::overload_cast<IntWrapper>(&IntWrapper::operator()), nb::arg("b"))
        .def("__call__",
            nb::overload_cast<int>(&IntWrapper::operator()), nb::arg("b"))
        ;


    auto pyClassIntWrapperSpaceship =
        nb::class_<IntWrapperSpaceship>
            (m, "IntWrapperSpaceship", "")
        .def_rw("value", &IntWrapperSpaceship::value, "")
        .def(nb::init<int>(),
            nb::arg("v"))
        .def("__lt__",
            [](IntWrapperSpaceship & self, IntWrapperSpaceship & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  < 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__le__",
            [](IntWrapperSpaceship & self, IntWrapperSpaceship & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  <= 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__eq__",
            [](IntWrapperSpaceship & self, IntWrapperSpaceship & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  == 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__ge__",
            [](IntWrapperSpaceship & self, IntWrapperSpaceship & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  >= 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__gt__",
            [](IntWrapperSpaceship & self, IntWrapperSpaceship & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  > 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__lt__",
            [](IntWrapperSpaceship & self, int & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  < 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__le__",
            [](IntWrapperSpaceship & self, int & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  <= 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__eq__",
            [](IntWrapperSpaceship & self, int & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  == 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__ge__",
            [](IntWrapperSpaceship & self, int & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  >= 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        .def("__gt__",
            [](IntWrapperSpaceship & self, int & o) -> bool
            {
                auto cmp = [&self](auto&& other) -> bool {
                    return self.operator<=>(other)  > 0;
                };

                return cmp(o);
            },     nb::arg("o"))
        ;


    m.def("call_guard_tester",
        call_guard_tester,
        "// py::call_guard<CallGuardLogger>()",
        nb::call_guard<CallGuardLogger>());


    auto pyClassCallGuardLogger =
        nb::class_<CallGuardLogger>
            (m, "CallGuardLogger", " ============================================================================\n CallGuardLogger: dummy call guard for the tests\n ============================================================================")
        .def(nb::init<>())
        .def_rw_static("nb_construct", &CallGuardLogger::nb_construct, "")
        .def_rw_static("nb_destroy", &CallGuardLogger::nb_destroy, "")
        ;


    m.def("add_templated",
        nb::overload_cast<int, int>(AddTemplated<int>), nb::arg("a"), nb::arg("b"));
    m.def("add_templated",
        nb::overload_cast<double, double>(AddTemplated<double>), nb::arg("a"), nb::arg("b"));
    m.def("add_templated",
        nb::overload_cast<std::string, std::string>(AddTemplated<std::string>), nb::arg("a"), nb::arg("b"));

    m.def("sum_vector_and_c_array_int",
        [](std::vector<int> xs, const std::array<int, 2>& other_values) -> int
        {
            auto SumVectorAndCArray_adapt_fixed_size_c_arrays = [](std::vector<int> xs, const std::array<int, 2>& other_values) -> int
            {
                auto lambda_result = SumVectorAndCArray<int>(xs, other_values.data());
                return lambda_result;
            };

            return SumVectorAndCArray_adapt_fixed_size_c_arrays(xs, other_values);
        },     nb::arg("xs"), nb::arg("other_values"));
    m.def("sum_vector_and_c_array_string",
        [](std::vector<std::string> xs, const std::array<std::string, 2>& other_values) -> std::string
        {
            auto SumVectorAndCArray_adapt_fixed_size_c_arrays = [](std::vector<std::string> xs, const std::array<std::string, 2>& other_values) -> std::string
            {
                auto lambda_result = SumVectorAndCArray<std::string>(xs, other_values.data());
                return lambda_result;
            };

            return SumVectorAndCArray_adapt_fixed_size_c_arrays(xs, other_values);
        },     nb::arg("xs"), nb::arg("other_values"));


    auto pyClassFooTemplateFunctionTest =
        nb::class_<FooTemplateFunctionTest>
            (m, "FooTemplateFunctionTest", "")
        .def(nb::init<>()) // implicit default constructor
        .def("sum_vector_and_c_array_int",
            [](FooTemplateFunctionTest & self, std::vector<int> xs, const std::array<int, 2>& other_values) -> int
            {
                auto SumVectorAndCArray_adapt_fixed_size_c_arrays = [&self](std::vector<int> xs, const std::array<int, 2>& other_values) -> int
                {
                    auto lambda_result = self.SumVectorAndCArray<int>(xs, other_values.data());
                    return lambda_result;
                };

                return SumVectorAndCArray_adapt_fixed_size_c_arrays(xs, other_values);
            },     nb::arg("xs"), nb::arg("other_values"))
        .def("sum_vector_and_c_array_string",
            [](FooTemplateFunctionTest & self, std::vector<std::string> xs, const std::array<std::string, 2>& other_values) -> std::string
            {
                auto SumVectorAndCArray_adapt_fixed_size_c_arrays = [&self](std::vector<std::string> xs, const std::array<std::string, 2>& other_values) -> std::string
                {
                    auto lambda_result = self.SumVectorAndCArray<std::string>(xs, other_values.data());
                    return lambda_result;
                };

                return SumVectorAndCArray_adapt_fixed_size_c_arrays(xs, other_values);
            },     nb::arg("xs"), nb::arg("other_values"))
        ;


    auto pyClassMyTemplateClass_int =
        nb::class_<MyTemplateClass<int>>
            (m, "MyTemplateClass_int", "")
        .def_rw("values", &MyTemplateClass<int>::values, "")
        .def(nb::init<>(),
            "Standard constructor")
        .def("__init__",
            [](MyTemplateClass<int> * self, const std::array<int, 2>& v)
            {
                auto ctor_wrapper = [](MyTemplateClass<int>* self, const int v[2]) ->  void
                {
                    new(self) MyTemplateClass<int>(v); // placement new
                };
                auto ctor_wrapper_adapt_fixed_size_c_arrays = [&ctor_wrapper](MyTemplateClass<int> * self, const std::array<int, 2>& v)
                {
                    ctor_wrapper(self, v.data());
                };

                ctor_wrapper_adapt_fixed_size_c_arrays(self, v);
            },
            nb::arg("v"),
            "Constructor that will need a parameter adaptation")
        .def("sum",
            &MyTemplateClass<int>::sum, "Standard method")
        .def("sum2",
            [](MyTemplateClass<int> & self, const std::array<int, 2>& v) -> int
            {
                auto sum2_adapt_fixed_size_c_arrays = [&self](const std::array<int, 2>& v) -> int
                {
                    auto lambda_result = self.sum2(v.data());
                    return lambda_result;
                };

                return sum2_adapt_fixed_size_c_arrays(v);
            },
            nb::arg("v"),
            "Method that requires a parameter adaptation")
        ;
    auto pyClassMyTemplateClass_string =
        nb::class_<MyTemplateClass<std::string>>
            (m, "MyTemplateClass_string", "")
        .def_rw("values", &MyTemplateClass<std::string>::values, "")
        .def(nb::init<>(),
            "Standard constructor")
        .def("__init__",
            [](MyTemplateClass<std::string> * self, const std::array<std::string, 2>& v)
            {
                auto ctor_wrapper = [](MyTemplateClass<std::string>* self, const std::string v[2]) ->  void
                {
                    new(self) MyTemplateClass<std::string>(v); // placement new
                };
                auto ctor_wrapper_adapt_fixed_size_c_arrays = [&ctor_wrapper](MyTemplateClass<std::string> * self, const std::array<std::string, 2>& v)
                {
                    ctor_wrapper(self, v.data());
                };

                ctor_wrapper_adapt_fixed_size_c_arrays(self, v);
            },
            nb::arg("v"),
            "Constructor that will need a parameter adaptation")
        .def("sum",
            &MyTemplateClass<std::string>::sum, "Standard method")
        .def("sum2",
            [](MyTemplateClass<std::string> & self, const std::array<std::string, 2>& v) -> std::string
            {
                auto sum2_adapt_fixed_size_c_arrays = [&self](const std::array<std::string, 2>& v) -> std::string
                {
                    auto lambda_result = self.sum2(v.data());
                    return lambda_result;
                };

                return sum2_adapt_fixed_size_c_arrays(v);
            },
            nb::arg("v"),
            "Method that requires a parameter adaptation")
        ;
    // #ifdef __cplusplus
    //
    // #endif
    //

    m.def("extern_c_add",
        extern_c_add, nb::arg("a"), nb::arg("b"));

    m.def("foo_void_param",
        foo_void_param);

    m.def("foo_unnamed_param",
        foo_unnamed_param, nb::arg("param_0"), nb::arg("param_1"), nb::arg("param_2"));
    m.attr("ANSWER_ZERO_COMMENTED") = 0;
    m.attr("ANSWER_ONE_COMMENTED") = 1;
    m.attr("HEXVALUE") = 0x43242;
    m.attr("OCTALVALUE") = 043242;
    m.attr("STRING") = "Hello";
    m.attr("FLOAT") = 3.14;
    // #ifdef __cplusplus
    //
    // #endif
    //


    auto pyClassSmartElem =
        nb::class_<SmartElem>
            (m, "SmartElem", " With pybind11, SmartElem is mentioned in options.class_held_as_shared__regex\n (because it might be stored as a shared_ptr in the generated code)")
        .def("__init__", [](SmartElem * self, int x = 0)
        {
            new (self) SmartElem();  // placement new
            auto r_ctor_ = self;
            r_ctor_->x = x;
        },
        nb::arg("x") = 0
        )
        .def_rw("x", &SmartElem::x, "")
        ;


    m.def("make_shared_elem",
        make_shared_elem, nb::arg("x"));


    auto pyClassElemContainer =
        nb::class_<ElemContainer>
            (m, "ElemContainer", "")
        .def(nb::init<>())
        .def_rw("vec", &ElemContainer::vec, "")
        .def_rw("shared_ptr", &ElemContainer::shared_ptr, "")
        .def_rw("vec_shared_ptrs", &ElemContainer::vec_shared_ptrs, "")
        ;


    auto pyClassFooBrace =
        nb::class_<FooBrace>
            (m, "FooBrace", "")
        .def("__init__", [](FooBrace * self, std::vector<int> int_values = {1, 2, 3})
        {
            new (self) FooBrace();  // placement new
            auto r_ctor_ = self;
            r_ctor_->int_values = int_values;
        },
        nb::arg("int_values") = std::vector<int>{1, 2, 3}
        )
        .def_rw("int_values", &FooBrace::int_values, "")
        .def_rw("dict_string_int", &FooBrace::dict_string_int, "")
        ;


    m.def("fn_brace",
        FnBrace, nb::arg("foo_brace") = FooBrace{}, nb::arg("ints") = std::vector<int>{1, 2, 3});

    { // <namespace MathFunctions>
        nb::module_ pyNsMathFunctions = m.def_submodule("math_functions", " Vectorizable functions example\n    Numeric functions (i.e. function accepting and returning only numeric params or py::array), can be vectorized\n    i.e. they will accept numpy arrays as an input.\n\n Auto-vectorization is enabled via the following options:\n     options.fn_namespace_vectorize__regex: str = r\"^MathFunctions$\"\n     options.fn_vectorize__regex = r\".*\"\n");
        pyNsMathFunctions.def("vectorizable_sum",
            MathFunctions::vectorizable_sum, nb::arg("x"), nb::arg("y"));
    } // </namespace MathFunctions>

    { // <namespace Animals>
        nb::module_ pyNsAnimals = m.def_submodule("animals", "");
        auto pyNsAnimals_ClassAnimal =
            nb::class_<Animals::Animal>
                (pyNsAnimals, "Animal", "")
            .def(nb::init<const std::string &>(),
                nb::arg("name"))
            .def_rw("name", &Animals::Animal::name, "")
            ;


        auto pyNsAnimals_ClassDog =
            nb::class_<Animals::Dog, Animals::Animal>
                (pyNsAnimals, "Dog", "")
            .def(nb::init<const std::string &>(),
                nb::arg("name"))
            .def("bark",
                &Animals::Dog::bark)
            ;
    } // </namespace Animals>

    { // <namespace AAA>
        nb::module_ pyNsAAA = m.def_submodule("aaa", "");
        auto pyNsAAA_ClassCopyable_Template_int =
            nb::class_<AAA::Copyable_Template<int>>
                (pyNsAAA, "Copyable_Template_int", "")
            .def("__init__", [](AAA::Copyable_Template<int> * self, int value = int())
            {
                new (self) AAA::Copyable_Template<int>();  // placement new
                auto r_ctor_ = self;
                r_ctor_->value = value;
            },
            nb::arg("value") = int()
            )
            .def_rw("value", &AAA::Copyable_Template<int>::value, "")
            .def("__copy__",  [](const AAA::Copyable_Template<int> &self) {
                return AAA::Copyable_Template<int>(self);
            })
            .def("__deepcopy__",  [](const AAA::Copyable_Template<int> &self, nb::dict) {
                return AAA::Copyable_Template<int>(self);
            }, nb::arg("memo"))    ;
    } // </namespace AAA>

    { // <namespace Root>
        nb::module_ pyNsRoot = m.def_submodule("root", "");
        { // <namespace Inner>
            nb::module_ pyNsRoot_NsInner = pyNsRoot.def_submodule("inner", "");
            auto pyNsRoot_NsInner_ClassMyVirtualClass =
                nb::class_<Root::Inner::MyVirtualClass, Root::Inner::MyVirtualClass_trampoline>
                    (pyNsRoot_NsInner, "MyVirtualClass", "")
                .def(nb::init<>()) // implicit default constructor
                .def("foo_concrete",
                    &Root::Inner::MyVirtualClass::foo_concrete, nb::arg("x"), nb::arg("name"))
                .def("foo_virtual_public_pure",
                    &Root::Inner::MyVirtualClass::foo_virtual_public_pure)
                .def("foo_virtual_protected",
                    &Root::Inner::MyVirtualClass_publicist::foo_virtual_protected, nb::arg("x"))
                .def("foo_virtual_protected_const_const",
                    &Root::Inner::MyVirtualClass_publicist::foo_virtual_protected_const_const, nb::arg("name"))
                ;


            auto pyNsRoot_NsInner_ClassMyVirtualDerivate =
                nb::class_<Root::Inner::MyVirtualDerivate, Root::Inner::MyVirtualClass, Root::Inner::MyVirtualDerivate_trampoline>
                    (pyNsRoot_NsInner, "MyVirtualDerivate", " Here, we test Combining virtual functions and inheritance\n See https://pybind11.readthedocs.io/en/stable/advanced/classes.html#combining-virtual-functions-and-inheritance")
                .def(nb::init<>())
                .def("foo_virtual_public_pure",
                    &Root::Inner::MyVirtualDerivate::foo_virtual_public_pure)
                .def("foo_derivate",
                    &Root::Inner::MyVirtualDerivate::foo_derivate)
                ;
        } // </namespace Inner>

    } // </namespace Root>

    { // <namespace SomeNamespace>
        nb::module_ pyNsSomeNamespace = m.def_submodule("some_namespace", "namespace SomeNamespace");
        auto pyNsSomeNamespace_ClassParentStruct =
            nb::class_<SomeNamespace::ParentStruct>
                (pyNsSomeNamespace, "ParentStruct", "");

        { // inner classes & enums of ParentStruct
            auto pyNsSomeNamespace_ClassParentStruct_ClassInnerStruct =
                nb::class_<SomeNamespace::ParentStruct::InnerStruct>
                    (pyNsSomeNamespace_ClassParentStruct, "InnerStruct", "")
                .def_rw("value", &SomeNamespace::ParentStruct::InnerStruct::value, "")
                .def(nb::init<int>(),
                    nb::arg("value") = 10)
                .def("add",
                    &SomeNamespace::ParentStruct::InnerStruct::add, nb::arg("a"), nb::arg("b"))
                ;
            auto pyEnumInnerEnum =
                nb::enum_<SomeNamespace::ParentStruct::InnerEnum>(pyNsSomeNamespace_ClassParentStruct, "InnerEnum", nb::is_arithmetic(), "")
                    .value("zero", SomeNamespace::ParentStruct::InnerEnum::Zero, "")
                    .value("one", SomeNamespace::ParentStruct::InnerEnum::One, "")
                    .value("two", SomeNamespace::ParentStruct::InnerEnum::Two, "")
                    .value("three", SomeNamespace::ParentStruct::InnerEnum::Three, "");
        } // end of inner classes & enums of ParentStruct

        pyNsSomeNamespace_ClassParentStruct
            .def("__init__", [](SomeNamespace::ParentStruct * self, SomeNamespace::ParentStruct::InnerStruct inner_struct = SomeNamespace::ParentStruct::InnerStruct(), SomeNamespace::ParentStruct::InnerEnum inner_enum = SomeNamespace::ParentStruct::InnerEnum::Three)
            {
                new (self) SomeNamespace::ParentStruct();  // placement new
                auto r_ctor_ = self;
                r_ctor_->inner_struct = inner_struct;
                r_ctor_->inner_enum = inner_enum;
            },
            nb::arg("inner_struct") = SomeNamespace::ParentStruct::InnerStruct(), nb::arg("inner_enum") = SomeNamespace::ParentStruct::InnerEnum::Three
            )
            .def_rw("inner_struct", &SomeNamespace::ParentStruct::inner_struct, "")
            .def_rw("inner_enum", &SomeNamespace::ParentStruct::inner_enum, "")
            ;
        auto pyNsSomeNamespace_ClassBlah =
            nb::class_<SomeNamespace::Blah>
                (pyNsSomeNamespace, "Blah", "struct Blah")
            .def(nb::init<>()) // implicit default constructor
            .def("toggle_bool_pointer",
                [](SomeNamespace::Blah & self, BoxedBool & v)
                {
                    auto ToggleBoolPointer_adapt_modifiable_immutable = [&self](BoxedBool & v)
                    {
                        bool * v_boxed_value = & (v.value);

                        self.ToggleBoolPointer(v_boxed_value);
                    };

                    ToggleBoolPointer_adapt_modifiable_immutable(v);
                },
                nb::arg("v"),
                "//, int vv[2])")
            .def("toggle_bool_pointer_get_points",
                [](SomeNamespace::Blah & self, BoxedBool & v, BoxedInt & vv_0, BoxedInt & vv_1)
                {
                    auto ToggleBoolPointerGetPoints_adapt_fixed_size_c_arrays = [&self](bool * v, BoxedInt & vv_0, BoxedInt & vv_1)
                    {
                        int vv_raw[2];
                        vv_raw[0] = vv_0.value;
                        vv_raw[1] = vv_1.value;

                        self.ToggleBoolPointerGetPoints(v, vv_raw);

                        vv_0.value = vv_raw[0];
                        vv_1.value = vv_raw[1];
                    };
                    auto ToggleBoolPointerGetPoints_adapt_modifiable_immutable = [&ToggleBoolPointerGetPoints_adapt_fixed_size_c_arrays](BoxedBool & v, BoxedInt & vv_0, BoxedInt & vv_1)
                    {
                        bool * v_boxed_value = & (v.value);

                        ToggleBoolPointerGetPoints_adapt_fixed_size_c_arrays(v_boxed_value, vv_0, vv_1);
                    };

                    ToggleBoolPointerGetPoints_adapt_modifiable_immutable(v, vv_0, vv_1);
                },     nb::arg("v"), nb::arg("vv_0"), nb::arg("vv_1"))
            .def("modify_string",
                [](SomeNamespace::Blah & self, BoxedString & s)
                {
                    auto ModifyString_adapt_modifiable_immutable = [&self](BoxedString & s)
                    {
                        std::string * s_boxed_value = & (s.value);

                        self.ModifyString(s_boxed_value);
                    };

                    ModifyString_adapt_modifiable_immutable(s);
                },     nb::arg("s"))
            .def("change_bool_int",
                [](SomeNamespace::Blah & self, const char * label, int value) -> std::tuple<bool, int>
                {
                    auto ChangeBoolInt_adapt_modifiable_immutable_to_return = [&self](const char * label, int value) -> std::tuple<bool, int>
                    {
                        int * value_adapt_modifiable = & value;

                        bool r = self.ChangeBoolInt(label, value_adapt_modifiable);
                        return std::make_tuple(r, value);
                    };

                    return ChangeBoolInt_adapt_modifiable_immutable_to_return(label, value);
                },     nb::arg("label"), nb::arg("value"))
            .def("add_inside_buffer",
                [](SomeNamespace::Blah & self, nb::ndarray<> & buffer, uint8_t number_to_add)
                {
                    auto add_inside_buffer_adapt_c_buffers = [&self](nb::ndarray<> & buffer, uint8_t number_to_add)
                    {
                        // Check if the array is 1D and C-contiguous
                        if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                            throw std::runtime_error("The array must be 1D and contiguous");

                        // convert nb::ndarray to C standard buffer (mutable)
                        void * buffer_from_pyarray = buffer.data();
                        size_t buffer_count = buffer.shape(0);
                        // Check the type of the ndarray (generic type and size)
                        //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                        uint8_t dtype_code_python_0 = buffer.dtype().code;
                        uint8_t dtype_code_cpp_0 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                        if (dtype_code_python_0 != dtype_code_cpp_0)
                            throw std::runtime_error(std::string(R"msg(
                                    Bad type! While checking the generic type (dtype_code=UInt)!
                                )msg"));
                        //   - Step 2: check the size of the type
                        size_t size_python_0 = buffer.dtype().bits / 8;
                        size_t size_cpp_0 = sizeof(uint8_t);
                        if (size_python_0 != size_cpp_0)
                            throw std::runtime_error(std::string(R"msg(
                                    Bad type! Size mismatch, while checking the size of the type (for param "buffer")!
                                )msg"));

                        self.add_inside_buffer(static_cast<uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), number_to_add);
                    };

                    add_inside_buffer_adapt_c_buffers(buffer, number_to_add);
                },     nb::arg("buffer"), nb::arg("number_to_add"))
            .def("templated_mul_inside_buffer",
                [](SomeNamespace::Blah & self, nb::ndarray<> & buffer, double factor)
                {
                    auto templated_mul_inside_buffer_adapt_c_buffers = [&self](nb::ndarray<> & buffer, double factor)
                    {
                        // Check if the array is 1D and C-contiguous
                        if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                            throw std::runtime_error("The array must be 1D and contiguous");

                        // convert nb::ndarray to C standard buffer (mutable)
                        void * buffer_from_pyarray = buffer.data();
                        size_t buffer_count = buffer.shape(0);

                        using np_uint_l = uint64_t;
                        using np_int_l = int64_t;

                        // Define a lambda to compute the letter code for the buffer type
                        auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                        {
                            #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                                const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                                    {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                                    {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                                    {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                                }};
                            #undef DCODE
                            for (const auto& [code_val, size, letter] : mappings)
                                if (code_val == dtype_code && size == sizeof_item)
                                    return letter;
                            throw std::runtime_error("Unsupported dtype");
                        };

                        // Compute the letter code for the buffer type
                        uint8_t dtype_code_buffer = buffer.dtype().code;
                        size_t sizeof_item_buffer = buffer.dtype().bits / 8;
                        char buffer_type = _nanobind_buffer_type_to_letter_code(dtype_code_buffer, sizeof_item_buffer);

                        // call the correct template version by casting
                        if (buffer_type == 'B')
                            self.templated_mul_inside_buffer(static_cast<uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'b')
                            self.templated_mul_inside_buffer(static_cast<int8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'H')
                            self.templated_mul_inside_buffer(static_cast<uint16_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'h')
                            self.templated_mul_inside_buffer(static_cast<int16_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'I')
                            self.templated_mul_inside_buffer(static_cast<uint32_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'i')
                            self.templated_mul_inside_buffer(static_cast<int32_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'L')
                            self.templated_mul_inside_buffer(static_cast<np_uint_l *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'l')
                            self.templated_mul_inside_buffer(static_cast<np_int_l *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'f')
                            self.templated_mul_inside_buffer(static_cast<float *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'd')
                            self.templated_mul_inside_buffer(static_cast<double *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'g')
                            self.templated_mul_inside_buffer(static_cast<long double *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'q')
                            self.templated_mul_inside_buffer(static_cast<long long *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        // If we reach this point, the array type is not supported!
                        else
                            throw std::runtime_error(std::string("Bad array type ('") + buffer_type + "') for param buffer");
                    };

                    templated_mul_inside_buffer_adapt_c_buffers(buffer, factor);
                },     nb::arg("buffer"), nb::arg("factor"))
            .def("const_array2_add",
                [](SomeNamespace::Blah & self, const std::array<int, 2>& values) -> int
                {
                    auto const_array2_add_adapt_fixed_size_c_arrays = [&self](const std::array<int, 2>& values) -> int
                    {
                        auto lambda_result = self.const_array2_add(values.data());
                        return lambda_result;
                    };

                    return const_array2_add_adapt_fixed_size_c_arrays(values);
                },     nb::arg("values"))
            .def("c_string_list_total_size",
                [](SomeNamespace::Blah & self, const std::vector<std::string> & items, BoxedInt & output_0, BoxedInt & output_1) -> size_t
                {
                    auto c_string_list_total_size_adapt_fixed_size_c_arrays = [&self](const char * const items[], int items_count, BoxedInt & output_0, BoxedInt & output_1) -> size_t
                    {
                        int output_raw[2];
                        output_raw[0] = output_0.value;
                        output_raw[1] = output_1.value;

                        auto lambda_result = self.c_string_list_total_size(items, items_count, output_raw);

                        output_0.value = output_raw[0];
                        output_1.value = output_raw[1];
                        return lambda_result;
                    };
                    auto c_string_list_total_size_adapt_c_string_list = [&c_string_list_total_size_adapt_fixed_size_c_arrays](const std::vector<std::string> & items, BoxedInt & output_0, BoxedInt & output_1) -> size_t
                    {
                        std::vector<const char *> items_ptrs;
                        items_ptrs.reserve(items.size());
                        for (const auto& v: items)
                            items_ptrs.push_back(v.c_str());
                        int items_count = static_cast<int>(items.size());

                        auto lambda_result = c_string_list_total_size_adapt_fixed_size_c_arrays(items_ptrs.data(), items_count, output_0, output_1);
                        return lambda_result;
                    };

                    return c_string_list_total_size_adapt_c_string_list(items, output_0, output_1);
                },     nb::arg("items"), nb::arg("output_0"), nb::arg("output_1"))
            ;
        { // <namespace SomeInnerNamespace>
            nb::module_ pyNsSomeNamespace_NsSomeInnerNamespace = pyNsSomeNamespace.def_submodule("some_inner_namespace", "namespace SomeInnerNamespace");
            pyNsSomeNamespace_NsSomeInnerNamespace.def("toggle_bool_pointer",
                [](BoxedBool & v)
                {
                    auto ToggleBoolPointer_adapt_modifiable_immutable = [](BoxedBool & v)
                    {
                        bool * v_boxed_value = & (v.value);

                        SomeNamespace::SomeInnerNamespace::ToggleBoolPointer(v_boxed_value);
                    };

                    ToggleBoolPointer_adapt_modifiable_immutable(v);
                },
                nb::arg("v"),
                "//, int vv[2])");

            pyNsSomeNamespace_NsSomeInnerNamespace.def("toggle_bool_pointer_get_points",
                [](BoxedBool & v, BoxedInt & vv_0, BoxedInt & vv_1)
                {
                    auto ToggleBoolPointerGetPoints_adapt_fixed_size_c_arrays = [](bool * v, BoxedInt & vv_0, BoxedInt & vv_1)
                    {
                        int vv_raw[2];
                        vv_raw[0] = vv_0.value;
                        vv_raw[1] = vv_1.value;

                        SomeNamespace::SomeInnerNamespace::ToggleBoolPointerGetPoints(v, vv_raw);

                        vv_0.value = vv_raw[0];
                        vv_1.value = vv_raw[1];
                    };
                    auto ToggleBoolPointerGetPoints_adapt_modifiable_immutable = [&ToggleBoolPointerGetPoints_adapt_fixed_size_c_arrays](BoxedBool & v, BoxedInt & vv_0, BoxedInt & vv_1)
                    {
                        bool * v_boxed_value = & (v.value);

                        ToggleBoolPointerGetPoints_adapt_fixed_size_c_arrays(v_boxed_value, vv_0, vv_1);
                    };

                    ToggleBoolPointerGetPoints_adapt_modifiable_immutable(v, vv_0, vv_1);
                },     nb::arg("v"), nb::arg("vv_0"), nb::arg("vv_1"));

            pyNsSomeNamespace_NsSomeInnerNamespace.def("modify_string",
                [](BoxedString & s)
                {
                    auto ModifyString_adapt_modifiable_immutable = [](BoxedString & s)
                    {
                        std::string * s_boxed_value = & (s.value);

                        SomeNamespace::SomeInnerNamespace::ModifyString(s_boxed_value);
                    };

                    ModifyString_adapt_modifiable_immutable(s);
                },     nb::arg("s"));

            pyNsSomeNamespace_NsSomeInnerNamespace.def("change_bool_int",
                [](const char * label, int value) -> std::tuple<bool, int>
                {
                    auto ChangeBoolInt_adapt_modifiable_immutable_to_return = [](const char * label, int value) -> std::tuple<bool, int>
                    {
                        int * value_adapt_modifiable = & value;

                        bool r = SomeNamespace::SomeInnerNamespace::ChangeBoolInt(label, value_adapt_modifiable);
                        return std::make_tuple(r, value);
                    };

                    return ChangeBoolInt_adapt_modifiable_immutable_to_return(label, value);
                },     nb::arg("label"), nb::arg("value"));

            pyNsSomeNamespace_NsSomeInnerNamespace.def("add_inside_buffer",
                [](nb::ndarray<> & buffer, uint8_t number_to_add)
                {
                    auto add_inside_buffer_adapt_c_buffers = [](nb::ndarray<> & buffer, uint8_t number_to_add)
                    {
                        // Check if the array is 1D and C-contiguous
                        if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                            throw std::runtime_error("The array must be 1D and contiguous");

                        // convert nb::ndarray to C standard buffer (mutable)
                        void * buffer_from_pyarray = buffer.data();
                        size_t buffer_count = buffer.shape(0);
                        // Check the type of the ndarray (generic type and size)
                        //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                        uint8_t dtype_code_python_0 = buffer.dtype().code;
                        uint8_t dtype_code_cpp_0 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                        if (dtype_code_python_0 != dtype_code_cpp_0)
                            throw std::runtime_error(std::string(R"msg(
                                    Bad type! While checking the generic type (dtype_code=UInt)!
                                )msg"));
                        //   - Step 2: check the size of the type
                        size_t size_python_0 = buffer.dtype().bits / 8;
                        size_t size_cpp_0 = sizeof(uint8_t);
                        if (size_python_0 != size_cpp_0)
                            throw std::runtime_error(std::string(R"msg(
                                    Bad type! Size mismatch, while checking the size of the type (for param "buffer")!
                                )msg"));

                        SomeNamespace::SomeInnerNamespace::add_inside_buffer(static_cast<uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), number_to_add);
                    };

                    add_inside_buffer_adapt_c_buffers(buffer, number_to_add);
                },     nb::arg("buffer"), nb::arg("number_to_add"));

            pyNsSomeNamespace_NsSomeInnerNamespace.def("templated_mul_inside_buffer",
                [](nb::ndarray<> & buffer, double factor)
                {
                    auto templated_mul_inside_buffer_adapt_c_buffers = [](nb::ndarray<> & buffer, double factor)
                    {
                        // Check if the array is 1D and C-contiguous
                        if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                            throw std::runtime_error("The array must be 1D and contiguous");

                        // convert nb::ndarray to C standard buffer (mutable)
                        void * buffer_from_pyarray = buffer.data();
                        size_t buffer_count = buffer.shape(0);

                        using np_uint_l = uint64_t;
                        using np_int_l = int64_t;

                        // Define a lambda to compute the letter code for the buffer type
                        auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                        {
                            #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                                const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                                    {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                                    {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                                    {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                                }};
                            #undef DCODE
                            for (const auto& [code_val, size, letter] : mappings)
                                if (code_val == dtype_code && size == sizeof_item)
                                    return letter;
                            throw std::runtime_error("Unsupported dtype");
                        };

                        // Compute the letter code for the buffer type
                        uint8_t dtype_code_buffer = buffer.dtype().code;
                        size_t sizeof_item_buffer = buffer.dtype().bits / 8;
                        char buffer_type = _nanobind_buffer_type_to_letter_code(dtype_code_buffer, sizeof_item_buffer);

                        // call the correct template version by casting
                        if (buffer_type == 'B')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'b')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<int8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'H')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<uint16_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'h')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<int16_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'I')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<uint32_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'i')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<int32_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'L')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<np_uint_l *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'l')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<np_int_l *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'f')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<float *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'd')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<double *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'g')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<long double *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        else if (buffer_type == 'q')
                            SomeNamespace::SomeInnerNamespace::templated_mul_inside_buffer(static_cast<long long *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                        // If we reach this point, the array type is not supported!
                        else
                            throw std::runtime_error(std::string("Bad array type ('") + buffer_type + "') for param buffer");
                    };

                    templated_mul_inside_buffer_adapt_c_buffers(buffer, factor);
                },     nb::arg("buffer"), nb::arg("factor"));

            pyNsSomeNamespace_NsSomeInnerNamespace.def("const_array2_add",
                [](const std::array<int, 2>& values) -> int
                {
                    auto const_array2_add_adapt_fixed_size_c_arrays = [](const std::array<int, 2>& values) -> int
                    {
                        auto lambda_result = SomeNamespace::SomeInnerNamespace::const_array2_add(values.data());
                        return lambda_result;
                    };

                    return const_array2_add_adapt_fixed_size_c_arrays(values);
                },     nb::arg("values"));

            pyNsSomeNamespace_NsSomeInnerNamespace.def("c_string_list_total_size",
                [](const std::vector<std::string> & items, BoxedInt & output_0, BoxedInt & output_1) -> size_t
                {
                    auto c_string_list_total_size_adapt_fixed_size_c_arrays = [](const char * const items[], int items_count, BoxedInt & output_0, BoxedInt & output_1) -> size_t
                    {
                        int output_raw[2];
                        output_raw[0] = output_0.value;
                        output_raw[1] = output_1.value;

                        auto lambda_result = SomeNamespace::SomeInnerNamespace::c_string_list_total_size(items, items_count, output_raw);

                        output_0.value = output_raw[0];
                        output_1.value = output_raw[1];
                        return lambda_result;
                    };
                    auto c_string_list_total_size_adapt_c_string_list = [&c_string_list_total_size_adapt_fixed_size_c_arrays](const std::vector<std::string> & items, BoxedInt & output_0, BoxedInt & output_1) -> size_t
                    {
                        std::vector<const char *> items_ptrs;
                        items_ptrs.reserve(items.size());
                        for (const auto& v: items)
                            items_ptrs.push_back(v.c_str());
                        int items_count = static_cast<int>(items.size());

                        auto lambda_result = c_string_list_total_size_adapt_fixed_size_c_arrays(items_ptrs.data(), items_count, output_0, output_1);
                        return lambda_result;
                    };

                    return c_string_list_total_size_adapt_c_string_list(items, output_0, output_1);
                },     nb::arg("items"), nb::arg("output_0"), nb::arg("output_1"));
        } // </namespace SomeInnerNamespace>

    } // </namespace SomeNamespace>

    { // <namespace Inner>
        nb::module_ pyNsInner = m.def_submodule("inner", "this is an inner namespace (this comment should become the namespace doc)");
        pyNsInner.def("foo_inner",
            Mylib::Inner::FooInner);
        pyNsInner.def("foo_inner2",
            Mylib::Inner::FooInner2);
    } // </namespace Inner>

    { // <namespace N>
        nb::module_ pyNsN = m.def_submodule("n", "");
        auto pyNsN_ClassS =
            nb::class_<N::S>
                (pyNsN, "S", "")
            .def(nb::init<>()) // implicit default constructor
            ;


        auto pyEnumEC =
            nb::enum_<N::EC>(pyNsN, "EC", nb::is_arithmetic(), "")
                .value("a", N::EC::a, "");


        auto pyEnumE =
            nb::enum_<N::E>(pyNsN, "E", nb::is_arithmetic(), "")
                .value("a", N::E_a, "");


        pyNsN.def("foo",
            nb::overload_cast<N::EC>(N::Foo), nb::arg("e") = N::EC::a);

        pyNsN.def("foo",
            nb::overload_cast<N::E>(N::Foo), nb::arg("e") = N::E_a);

        pyNsN.def("foo",
            nb::overload_cast<N::S, N::E>(N::Foo), nb::arg("s") = N::S(), nb::arg("e") = N::E_a);
    } // </namespace N>

    { // <namespace A>
        nb::module_ pyNsA = m.def_submodule("a", "");
        auto pyEnumFoo =
            nb::enum_<A::Foo>(pyNsA, "Foo", nb::is_arithmetic(), "")
                .value("foo1", A::Foo::Foo1, "")
                .value("foo2", A::Foo::Foo2, "")
                .value("foo3", A::Foo::Foo3, "");


        auto pyNsA_ClassClassNoDefaultCtor =
            nb::class_<A::ClassNoDefaultCtor>
                (pyNsA, "ClassNoDefaultCtor", " This struct has no default constructor, so a default named constructor\n will be provided for python")
            .def("__init__", [](A::ClassNoDefaultCtor * self, bool b = true, int a = int(), int c = 3, A::Foo foo = A::Foo::Foo1)
            {
                new (self) A::ClassNoDefaultCtor();  // placement new
                auto r_ctor_ = self;
                r_ctor_->b = b;
                r_ctor_->a = a;
                r_ctor_->c = c;
                r_ctor_->foo = foo;
            },
            nb::arg("b") = true, nb::arg("a") = int(), nb::arg("c") = 3, nb::arg("foo") = A::Foo::Foo1
            )
            .def_rw("b", &A::ClassNoDefaultCtor::b, "")
            .def_rw("a", &A::ClassNoDefaultCtor::a, "")
            .def_rw("c", &A::ClassNoDefaultCtor::c, "")
            .def_rw("foo", &A::ClassNoDefaultCtor::foo, "")
            .def_ro("s", &A::ClassNoDefaultCtor::s, "")
            ;
        { // <namespace N>
            nb::module_ pyNsA_NsN = pyNsA.def_submodule("n", "");
            auto pyNsA_NsN_ClassS =
                nb::class_<A::N::S>
                    (pyNsA_NsN, "S", "")
                .def(nb::init<>()) // implicit default constructor
                ;


            auto pyEnumEC =
                nb::enum_<A::N::EC>(pyNsA_NsN, "EC", nb::is_arithmetic(), "")
                    .value("a", A::N::EC::a, "");


            auto pyEnumE =
                nb::enum_<A::N::E>(pyNsA_NsN, "E", nb::is_arithmetic(), "")
                    .value("a", A::N::E_a, "");


            pyNsA_NsN.def("foo",
                nb::overload_cast<A::N::EC>(A::N::Foo), nb::arg("e") = A::N::EC::a);

            pyNsA_NsN.def("foo",
                nb::overload_cast<A::N::E>(A::N::Foo), nb::arg("e") = A::N::E_a);

            pyNsA_NsN.def("foo",
                nb::overload_cast<A::N::S, A::N::E>(A::N::Foo), nb::arg("s") = A::N::S(), nb::arg("e") = A::N::E_a);
        } // </namespace N>

    } // </namespace A>

    { // <namespace RootCustom>
        nb::module_ pyNsRootCustom = m.def_submodule("root_custom", "");
        auto pyNsRootCustom_ClassFoo =
            nb::class_<RootCustom::Foo>
                (pyNsRootCustom, "Foo", "")
            .def("__init__", [](RootCustom::Foo * self, int mValue = 0)
            {
                new (self) RootCustom::Foo();  // placement new
                auto r_ctor_ = self;
                r_ctor_->mValue = mValue;
            },
            nb::arg("m_value") = 0
            )
            .def_rw("m_value", &RootCustom::Foo::mValue, "")
            ;

        pyNsRootCustom_ClassFoo.def("get_value", [](const RootCustom::Foo& self){ return self.mValue; });
        pyNsRootCustom_ClassFoo.def("set_value", [](RootCustom::Foo& self, int value){ self.mValue = value; });



        // Example of adding a custom function to the submodule
        pyNsRootCustom.def("foo_namespace_function", []() -> int { return 53; });
    } // </namespace RootCustom>
    ////////////////////    </generated_from:mylib_amalgamation.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
    // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE END !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}
