// ============================================================================
// This file was autogenerated
// It is presented side to side with its source: c_style_buffer_to_pyarray_test.h
// It is not used in the compilation
//    (see integration_tests/bindings/pybind_mylib.cpp which contains the full binding
//     code, including this code)
// ============================================================================

#include <nanobind/nanobind.h>
#include <nanobind/stl/string.h>
#include <nanobind/stl/function.h>
#include "mylib_main/mylib.h"

namespace py = nanobind;

// <litgen_glue_code>  // Autogenerated code below! Do not edit!

// </litgen_glue_code> // Autogenerated code end


void py_init_module_mylib(py::module_& m)
{
    // <litgen_pydef> // Autogenerated code below! Do not edit!
    ////////////////////    <generated_from:c_style_buffer_to_pyarray_test.h>    ////////////////////
    m.def("add_inside_buffer",
        [](nb::ndarray<> & buffer, uint8_t number_to_add)
        {
            auto add_inside_buffer_adapt_c_buffers = [](nb::ndarray<> & buffer, uint8_t number_to_add)
            {
                // Check if the array is 1D and C-contiguous
                if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (mutable)
                void * buffer_from_pyarray = buffer.data();
                size_t buffer_count = buffer.shape(0);
                // Check the type of the ndarray (generic type and size)
                //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                uint8_t dtype_code_python_0 = buffer.dtype().code;
                uint8_t dtype_code_cpp_0 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                if (dtype_code_python_0 != dtype_code_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! While checking the generic type (dtype_code=UInt)!
                        )msg"));
                //   - Step 2: check the size of the type
                size_t size_python_0 = buffer.dtype().bits / 8;
                size_t size_cpp_0 = sizeof(uint8_t);
                if (size_python_0 != size_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! Size mismatch, while checking the size of the type (for param "buffer")!
                        )msg"));

                add_inside_buffer(static_cast<uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), number_to_add);
            };

            add_inside_buffer_adapt_c_buffers(buffer, number_to_add);
        },
        nb::arg("buffer"), nb::arg("number_to_add"),
        " add_inside_buffer: modifies a buffer by adding a value to its elements\n Will be published in python as:\n -->    def add_inside_buffer(buffer: np.ndarray, number_to_add: int) -> None:\n Warning, the python function will accept only uint8 numpy arrays, and check it at runtime!");

    m.def("buffer_sum",
        [](const nb::ndarray<> & buffer, int stride = -1) -> int
        {
            auto buffer_sum_adapt_c_buffers = [](const nb::ndarray<> & buffer, int stride = -1) -> int
            {
                // Check if the array is 1D and C-contiguous
                if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (const)
                const void * buffer_from_pyarray = buffer.data();
                size_t buffer_count = buffer.shape(0);
                // Check the type of the ndarray (generic type and size)
                //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                uint8_t dtype_code_python_0 = buffer.dtype().code;
                uint8_t dtype_code_cpp_0 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                if (dtype_code_python_0 != dtype_code_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! While checking the generic type (dtype_code=UInt)!
                        )msg"));
                //   - Step 2: check the size of the type
                size_t size_python_0 = buffer.dtype().bits / 8;
                size_t size_cpp_0 = sizeof(uint8_t);
                if (size_python_0 != size_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! Size mismatch, while checking the size of the type (for param "buffer")!
                        )msg"));

                // process stride default value (which was a sizeof in C++)
                int buffer_stride = stride;
                if (buffer_stride == -1)
                    buffer_stride = (int)buffer.itemsize();

                auto lambda_result = buffer_sum(static_cast<const uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), static_cast<size_t>(buffer_stride));
                return lambda_result;
            };

            return buffer_sum_adapt_c_buffers(buffer, stride);
        },
        nb::arg("buffer"), nb::arg("stride") = -1,
        " buffer_sum: returns the sum of a *const* buffer\n Will be published in python as:\n -->    def buffer_sum(buffer: np.ndarray, stride: int = -1) -> int:");

    m.def("add_inside_two_buffers",
        [](nb::ndarray<> & buffer_1, nb::ndarray<> & buffer_2, uint8_t number_to_add)
        {
            auto add_inside_two_buffers_adapt_c_buffers = [](nb::ndarray<> & buffer_1, nb::ndarray<> & buffer_2, uint8_t number_to_add)
            {
                // Check if the array is 1D and C-contiguous
                if (! (buffer_1.ndim() == 1 && buffer_1.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (mutable)
                void * buffer_1_from_pyarray = buffer_1.data();
                size_t buffer_1_count = buffer_1.shape(0);
                // Check the type of the ndarray (generic type and size)
                //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                uint8_t dtype_code_python_0 = buffer_1.dtype().code;
                uint8_t dtype_code_cpp_0 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                if (dtype_code_python_0 != dtype_code_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! While checking the generic type (dtype_code=UInt)!
                        )msg"));
                //   - Step 2: check the size of the type
                size_t size_python_0 = buffer_1.dtype().bits / 8;
                size_t size_cpp_0 = sizeof(uint8_t);
                if (size_python_0 != size_cpp_0)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! Size mismatch, while checking the size of the type (for param "buffer_1")!
                        )msg"));

                // Check if the array is 1D and C-contiguous
                if (! (buffer_2.ndim() == 1 && buffer_2.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (mutable)
                void * buffer_2_from_pyarray = buffer_2.data();
                size_t buffer_2_count = buffer_2.shape(0);
                // Check the type of the ndarray (generic type and size)
                //   - Step 1: check the generic type (one of dtype_code::Int, UInt, Float, Bfloat, Complex, Bool = 6);
                uint8_t dtype_code_python_1 = buffer_2.dtype().code;
                uint8_t dtype_code_cpp_1 = static_cast<uint8_t>(nb::dlpack::dtype_code::UInt);
                if (dtype_code_python_1 != dtype_code_cpp_1)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! While checking the generic type (dtype_code=UInt)!
                        )msg"));
                //   - Step 2: check the size of the type
                size_t size_python_1 = buffer_2.dtype().bits / 8;
                size_t size_cpp_1 = sizeof(uint8_t);
                if (size_python_1 != size_cpp_1)
                    throw std::runtime_error(std::string(R"msg(
                            Bad type! Size mismatch, while checking the size of the type (for param "buffer_2")!
                        )msg"));

                add_inside_two_buffers(static_cast<uint8_t *>(buffer_1_from_pyarray), static_cast<uint8_t *>(buffer_2_from_pyarray), static_cast<size_t>(buffer_2_count), number_to_add);
            };

            add_inside_two_buffers_adapt_c_buffers(buffer_1, buffer_2, number_to_add);
        },
        nb::arg("buffer_1"), nb::arg("buffer_2"), nb::arg("number_to_add"),
        " add_inside_two_buffers: modifies two mutable buffers\n litgen will detect that this function uses two buffers of same size.\n Will be published in python as:\n -->    def add_inside_two_buffers(buffer_1: np.ndarray, buffer_2: np.ndarray, number_to_add: int) -> None:");

    m.def("templated_mul_inside_buffer",
        [](nb::ndarray<> & buffer, double factor)
        {
            auto templated_mul_inside_buffer_adapt_c_buffers = [](nb::ndarray<> & buffer, double factor)
            {
                // Check if the array is 1D and C-contiguous
                if (! (buffer.ndim() == 1 && buffer.stride(0) == 1))
                    throw std::runtime_error("The array must be 1D and contiguous");

                // convert nb::ndarray to C standard buffer (mutable)
                void * buffer_from_pyarray = buffer.data();
                size_t buffer_count = buffer.shape(0);

                using np_uint_l = uint64_t;
                using np_int_l = int64_t;

                // Define a lambda to compute the letter code for the buffer type
                auto _nanobind_buffer_type_to_letter_code = [](uint8_t dtype_code, size_t sizeof_item)  -> char
                {
                    #define DCODE(T) static_cast<uint8_t>(nb::dlpack::dtype_code::T)
                        const std::array<std::tuple<uint8_t, size_t, char>, 11> mappings = {{
                            {DCODE(UInt), 1, 'B'}, {DCODE(UInt), 2, 'H'}, {DCODE(UInt), 4, 'I'}, {DCODE(UInt), 8, 'L'},
                            {DCODE(Int), 1, 'b'}, {DCODE(Int), 2, 'h'}, {DCODE(Int), 4, 'i'}, {DCODE(Int), 8, 'l'},
                            {DCODE(Float), 4, 'f'}, {DCODE(Float), 8, 'd'}, {DCODE(Float), 16, 'g'}
                        }};
                    #undef DCODE
                    for (const auto& [code_val, size, letter] : mappings)
                        if (code_val == dtype_code && size == sizeof_item)
                            return letter;
                    throw std::runtime_error("Unsupported dtype");
                };

                // Compute the letter code for the buffer type
                uint8_t dtype_code_buffer = buffer.dtype().code;
                size_t sizeof_item_buffer = buffer.dtype().bits / 8;
                char buffer_type = _nanobind_buffer_type_to_letter_code(dtype_code_buffer, sizeof_item_buffer);

                // call the correct template version by casting
                if (buffer_type == 'B')
                    templated_mul_inside_buffer(static_cast<uint8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'b')
                    templated_mul_inside_buffer(static_cast<int8_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'H')
                    templated_mul_inside_buffer(static_cast<uint16_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'h')
                    templated_mul_inside_buffer(static_cast<int16_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'I')
                    templated_mul_inside_buffer(static_cast<uint32_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'i')
                    templated_mul_inside_buffer(static_cast<int32_t *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'L')
                    templated_mul_inside_buffer(static_cast<np_uint_l *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'l')
                    templated_mul_inside_buffer(static_cast<np_int_l *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'f')
                    templated_mul_inside_buffer(static_cast<float *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'd')
                    templated_mul_inside_buffer(static_cast<double *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'g')
                    templated_mul_inside_buffer(static_cast<long double *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                else if (buffer_type == 'q')
                    templated_mul_inside_buffer(static_cast<long long *>(buffer_from_pyarray), static_cast<size_t>(buffer_count), factor);
                // If we reach this point, the array type is not supported!
                else
                    throw std::runtime_error(std::string("Bad array type ('") + buffer_type + "') for param buffer");
            };

            templated_mul_inside_buffer_adapt_c_buffers(buffer, factor);
        },
        nb::arg("buffer"), nb::arg("factor"),
        " templated_mul_inside_buffer: template function that modifies an array by multiplying its elements by a given factor\n litgen will detect that this function can be published as using a numpy array.\n It will be published in python as:\n -->    def mul_inside_buffer(buffer: np.ndarray, factor: float) -> None:\n\n The type will be detected at runtime and the correct template version will be called accordingly!\n An error will be thrown if the numpy array numeric type is not supported.");
    ////////////////////    </generated_from:c_style_buffer_to_pyarray_test.h>    ////////////////////

    // </litgen_pydef> // Autogenerated code end
}
