**Pyntfa**
======

## Description

**Pyntfa* is a python package for non-stationary time-frequency analysis. 
This package has a variety of applications in both exploration and earthquake seismology. The initial version of this package was held at https://github.com/chenyk1990/pyntfa, which is no longer maintained since 11/25/2024.

## Reference

Chen, Y., 2021, Nonstationary local time-frequency transform, Geophysics, 86(3), V245–V254.

Chen, Y., et al., 2025, Pyntfa: A python package for non-stationary time-frequency analysis, TBD.

BibTeX:

	@article{ntfa,
	  title={Nonstationary local time-frequency transform},
	  author={Yangkang Chen},
	  journal={Geophysics},
	  volume={86},
	  number={3},
	  issue={3},
	  pages={V245–V254},
	  doi={10.1190/geo2020-0298.1},
	  year={2021}
	}

    @article{pyntfa,
      title={PYntfa: A python package for non-stationary time-frequency analysis},
      author={Yangkang Chen and co-authors},
      journal={TBD},
      volume={TBD},
      number={TBD},
      issue={TBD},
      pages={TBD},
      doi={TBD},
      year={2025}
    }
    
-----------
## Copyright
    The pyntfa developing team, 2021-present
-----------

## License
    GNU General Public License, Version 3
    (http://www.gnu.org/copyleft/gpl.html)   

-----------

## Install
Using the latest version (Suggested)

    git clone https://github.com/aaspip/pyntfa
    cd pyntfa
    pip install -v -e .
    
or using Pypi

    pip install pyntfa

or 

    pip install git+https://github.com/aaspip/pyntfa
    
-----------
## Examples
    The "demo" directory contains all runable scripts to demonstrate different applications of pyntfa. 

-----------
## Dependence Packages
* scipy 
* numpy 
* matplotlib

-----------
## Modules
    xxx.py  -> description
    
-----------
## Development
    The development team welcomes voluntary contributions from any open-source enthusiast. 
    If you want to make contribution to this project, feel free to contact the development team. 

-----------
## Contact
    Regarding any questions, bugs, developments, collaborations, please contact  
    Yangkang Chen
    chenyk2016@gmail.com

-----------
## Gallery
The gallery figures of the pyntfapackage can be found at
    https://github.com/aaspip/gallery/tree/main/pyntfa
Each figure in the gallery directory corresponds to a DEMO script in the "demo" directory with the exactly the same file name.

The following figure shows a 1D synthetic example using the pyntfa package. Generated by [demos/test_pyntfa_chirp.py](https://github.com/aaspip/pyntfa/tree/main/demos/test_pyntfa_chirp.py)
<img src='https://github.com/aaspip/gallery/blob/main/pyntfa/test_pyntfa_syn1d1.png' alt='comp' width=960/>

We can further boost the resolution by the following example by

[demos/test_pyntfa_chirp.py](https://github.com/aaspip/pyntfa/tree/main/demos/test_pyntfa_chirp.py)
<img src='https://github.com/aaspip/gallery/blob/main/pyntfa/test_pyntfa_syn1d2.png' alt='comp' width=960/>

A comparion between CWT and NTFA via a noise test (this example also reproduces the Figure 4 in Zhang et al., 2020, Convolutional neural networks for microseismic waveform classification and arrival picking, Geophysics, 85, WA227-WA240). Generated by 

[demos/test_pyntfa_noise_cwtVSntfa.py](https://github.com/aaspip/pyntfa/tree/main/demos/test_pyntfa_noise_cwtVSntfa.py)
<img src='https://github.com/aaspip/gallery/blob/main/pyntfa/test_pyntfa_noise_cwtVSntfa.png' alt='comp' width=960/>

The following figure shows another example on strongly non-stationary 1D synthetic signal using the pyntfa package. Generated by [demos/test_pyntfa_chao.py](https://github.com/aaspip/pyntfa/tree/main/demos/test_pyntfa_chao.py)
<img src='https://github.com/aaspip/gallery/blob/main/pyntfa/test_pyntfa_chao.png' alt='comp' width=960/>


The following figure shows an application on one USArray trace (This example reproduces the Figure 5&6 in Chen, 2021, Nonstationary local time-frequency transform, Geophysics, 86(3), V245–V254.)
[demos/test_pyntfa_usarray1d.py](https://github.com/aaspip/pyntfa/tree/main/demos/test_pyntfa_usarray1d.py)
<img src='https://github.com/aaspip/gallery/blob/main/pyntfa/test_pyntfa_usarray1d.png' alt='comp' width=960/>


The following figure shows an application on the LIGO data (for detecting gravitational wave signal)
[demos/test_pyntfa_ligo.py](https://github.com/aaspip/pyntfa/tree/main/demos/test_pyntfa_ligo.py)
<img src='https://github.com/aaspip/gallery/blob/main/pyntfa/test_pyntfa_ligo.png' alt='comp' width=960/>

The following figure shows an application on the PcP phase (for studying core-mantle boundary)
[demos/test_pyntfa_pcp.py](https://github.com/aaspip/pyntfa/tree/main/demos/test_pyntfa_pcp.py)
<img src='https://github.com/aaspip/gallery/blob/main/pyntfa/test_pyntfa_pcp.png' alt='comp' width=960/>

The following figure shows an application on the SS precursor (for studying MTZ)
[demos/test_pyntfa_ss.py](https://github.com/aaspip/pyntfa/tree/main/demos/test_pyntfa_ss.py)
<img src='https://github.com/aaspip/gallery/blob/main/pyntfa/test_pyntfa_ss.png' alt='comp' width=960/>

