# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .chat_groups.client import AsyncChatGroupsClient, ChatGroupsClient
from .chats.client import AsyncChatsClient, ChatsClient
from .configs.client import AsyncConfigsClient, ConfigsClient
from .prompts.client import AsyncPromptsClient, PromptsClient
from .raw_client import AsyncRawEmpathicVoiceClient, RawEmpathicVoiceClient
from .tools.client import AsyncToolsClient, ToolsClient


class EmpathicVoiceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEmpathicVoiceClient(client_wrapper=client_wrapper)
        self.tools = ToolsClient(client_wrapper=client_wrapper)

        self.prompts = PromptsClient(client_wrapper=client_wrapper)

        self.configs = ConfigsClient(client_wrapper=client_wrapper)

        self.chats = ChatsClient(client_wrapper=client_wrapper)

        self.chat_groups = ChatGroupsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEmpathicVoiceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEmpathicVoiceClient
        """
        return self._raw_client


class AsyncEmpathicVoiceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEmpathicVoiceClient(client_wrapper=client_wrapper)
        self.tools = AsyncToolsClient(client_wrapper=client_wrapper)

        self.prompts = AsyncPromptsClient(client_wrapper=client_wrapper)

        self.configs = AsyncConfigsClient(client_wrapper=client_wrapper)

        self.chats = AsyncChatsClient(client_wrapper=client_wrapper)

        self.chat_groups = AsyncChatGroupsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEmpathicVoiceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEmpathicVoiceClient
        """
        return self._raw_client
