# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .encoding import Encoding


class AudioConfiguration(UniversalBaseModel):
    encoding: Encoding = pydantic.Field(default="linear16")
    """
    Encoding format of the audio input, such as `linear16`.
    """

    channels: int = pydantic.Field()
    """
    Number of audio channels.
    """

    sample_rate: int = pydantic.Field()
    """
    Audio sample rate. Number of samples per second in the audio input, measured in Hertz.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
