# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AudioOutput(UniversalBaseModel):
    """
    The type of message sent through the socket; for an Audio Output message, this must be `audio_output`.
    """

    type: typing.Literal["audio_output"] = pydantic.Field(default="audio_output")
    """
    The type of message sent through the socket; for an Audio Output message, this must be `audio_output`.
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Used to manage conversational state, correlate frontend and backend data, and persist conversations across EVI sessions.
    """

    id: str = pydantic.Field()
    """
    ID of the audio output. Allows the Audio Output message to be tracked and referenced.
    """

    index: int = pydantic.Field()
    """
    Index of the chunk of audio relative to the whole audio segment.
    """

    data: str = pydantic.Field()
    """
    Base64 encoded audio output. This encoded audio is transmitted to the client, where it can be decoded and played back as part of the user interaction.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
