# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class PostedConfigPromptSpec(UniversalBaseModel):
    """
    Identifies which prompt to use in a a config OR how to create a new prompt to use in the config
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Identifier for a Prompt. Formatted as a UUID.
    """

    version: typing.Optional[int] = pydantic.Field(default=None)
    """
    Version number for a Prompt. Version numbers should be integers. The combination of configId and version number is unique.
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Text used to create a new prompt for a particular config.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
