# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .return_chat_event_role import ReturnChatEventRole
from .return_chat_event_type import ReturnChatEventType


class ReturnChatEvent(UniversalBaseModel):
    """
    A description of a single event in a chat returned from the server
    """

    id: str = pydantic.Field()
    """
    Identifier for a Chat Event. Formatted as a UUID.
    """

    chat_id: str = pydantic.Field()
    """
    Identifier for the Chat this event occurred in. Formatted as a UUID.
    """

    timestamp: int = pydantic.Field()
    """
    Time at which the Chat Event occurred. Measured in seconds since the Unix epoch.
    """

    role: ReturnChatEventRole = pydantic.Field()
    """
    The role of the entity which generated the Chat Event. There are four possible values:
    - `USER`: The user, capable of sending user messages and interruptions.
    - `AGENT`: The assistant, capable of sending agent messages.
    - `SYSTEM`: The backend server, capable of transmitting errors.
    - `TOOL`: The function calling mechanism.
    """

    type: ReturnChatEventType = pydantic.Field()
    """
    Type of Chat Event. There are eleven Chat Event types:
    - `SYSTEM_PROMPT`: The system prompt used to initialize the session.
    - `CHAT_START_MESSAGE`: Marks the beginning of the chat session.
    - `USER_RECORDING_START_MESSAGE`: Marks when the client began streaming audio and the start of audio processing.
    - `USER_MESSAGE`: A message sent by the user.
    - `USER_INTERRUPTION`: A user-initiated interruption while the assistant is speaking.
    - `AGENT_MESSAGE`: A response generated by the assistant.
    - `FUNCTION_CALL`: A record of a tool invocation by the assistant.
    - `FUNCTION_CALL_RESPONSE`: The result of a previously invoked function or tool.
    - `PAUSE_ONSET`: Marks when the client sent a `pause_assistant_message` to pause the assistant.
    - `RESUME_ONSET`: Marks when the client sent a `resume_assistant_message` to resume the assistant.
    - `CHAT_END_MESSAGE`: Indicates the end of the chat session.
    """

    message_text: typing.Optional[str] = pydantic.Field(default=None)
    """
    The text of the Chat Event. This field contains the message content for each event type listed in the `type` field.
    """

    emotion_features: typing.Optional[str] = pydantic.Field(default=None)
    """
    Stringified JSON containing the prosody model inference results.
    
    EVI uses the prosody model to measure 48 expressions related to speech and vocal characteristics. These results contain a detailed emotional and tonal analysis of the audio. Scores typically range from 0 to 1, with higher values indicating a stronger confidence level in the measured attribute.
    """

    metadata: typing.Optional[str] = pydantic.Field(default=None)
    """
    Stringified JSON with additional metadata about the chat event.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
