# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ReturnEventMessageSpec(UniversalBaseModel):
    """
    A specific event message configuration to be returned from the server
    """

    enabled: bool = pydantic.Field()
    """
    Boolean indicating if this event message is enabled.
    
    If set to `true`, a message will be sent when the circumstances for the specific event are met.
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Text to use as the event message when the corresponding event occurs. If no text is specified, EVI will generate an appropriate message based on its current context and the system prompt.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
