# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ReturnTimeoutSpec(UniversalBaseModel):
    """
    A specific timeout configuration to be returned from the server
    """

    enabled: bool = pydantic.Field()
    """
    Boolean indicating if this timeout is enabled.
    
    If set to false, EVI will not timeout due to a specified duration being reached. However, the conversation will eventually disconnect after 1,800 seconds (30 minutes), which is the maximum WebSocket duration limit for EVI.
    """

    duration_secs: typing.Optional[int] = pydantic.Field(default=None)
    """
    Duration in seconds for the timeout (e.g. 600 seconds represents 10 minutes).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
