# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .chat_message import ChatMessage
from .inference import Inference
from .millisecond_interval import MillisecondInterval


class UserMessage(UniversalBaseModel):
    """
    When provided, the output is a user message.
    """

    type: typing.Literal["user_message"] = pydantic.Field(default="user_message")
    """
    The type of message sent through the socket; for a User Message, this must be `user_message`.
    
    This message contains both a transcript of the user's input and the expression measurement predictions if the input was sent as an [Audio Input message](/reference/speech-to-speech-evi/chat#send.AudioInput). Expression measurement predictions are not provided for a [User Input message](/reference/speech-to-speech-evi/chat#send.UserInput), as the prosody model relies on audio input and cannot process text alone.
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Used to manage conversational state, correlate frontend and backend data, and persist conversations across EVI sessions.
    """

    message: ChatMessage = pydantic.Field()
    """
    Transcript of the message.
    """

    models: Inference = pydantic.Field()
    """
    Inference model results.
    """

    time: MillisecondInterval = pydantic.Field()
    """
    Start and End time of user message.
    """

    from_text: bool = pydantic.Field()
    """
    Indicates if this message was inserted into the conversation as text from a [User Input](/reference/speech-to-speech-evi/chat#send.UserInput.text) message.
    """

    interim: bool = pydantic.Field()
    """
    Indicates whether this `UserMessage` contains an interim (unfinalized) transcript.
    
    - `true`: the transcript is provisional; words may be repeated or refined in subsequent `UserMessage` responses as additional audio is processed.
    - `false`: the transcript is final and complete.
    
    Interim transcripts are only sent when the [`verbose_transcription`](/reference/speech-to-speech-evi/chat#request.query.verbose_transcription) query parameter is set to `true` in the initial handshake.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
