# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .unconfigurable import Unconfigurable


class Face(UniversalBaseModel):
    """
    The Facial Emotional Expression model analyzes human facial expressions in images and videos. Results will be provided per frame for video files.

    Recommended input file types: `.png`, `.jpeg`, `.mp4`
    """

    fps_pred: typing.Optional[float] = pydantic.Field(default=None)
    """
    Number of frames per second to process. Other frames will be omitted from the response. Set to `0` to process every frame.
    """

    prob_threshold: typing.Optional[float] = pydantic.Field(default=None)
    """
    Face detection probability threshold. Faces detected with a probability less than this threshold will be omitted from the response.
    """

    identify_faces: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to return identifiers for faces across frames. If `true`, unique identifiers will be assigned to face bounding boxes to differentiate different faces. If `false`, all faces will be tagged with an `unknown` ID.
    """

    min_face_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    Minimum bounding box side length in pixels to treat as a face. Faces detected with a bounding box side length in pixels less than this threshold will be omitted from the response.
    """

    facs: typing.Optional[Unconfigurable] = None
    descriptions: typing.Optional[Unconfigurable] = None
    save_faces: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to extract and save the detected faces in the artifacts zip created by each job.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
