# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .models import Models
from .transcription import Transcription


class InferenceBaseRequest(UniversalBaseModel):
    models: typing.Optional[Models] = pydantic.Field(default=None)
    """
    Specify the models to use for inference.
    
    If this field is not explicitly set, then all models will run by default.
    """

    transcription: typing.Optional[Transcription] = None
    urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    URLs to the media files to be processed. Each must be a valid public URL to a media file (see recommended input filetypes) or an archive (`.zip`, `.tar.gz`, `.tar.bz2`, `.tar.xz`) of media files.
    
    If you wish to supply more than 100 URLs, consider providing them as an archive (`.zip`, `.tar.gz`, `.tar.bz2`, `.tar.xz`).
    """

    text: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Text supplied directly to our Emotional Language and NER models for analysis.
    """

    callback_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    If provided, a `POST` request will be made to the URL with the generated predictions on completion or the error message on failure.
    """

    notify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to send an email notification to the user upon job completion/failure.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
