# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .emotion_score import EmotionScore
from .time_interval import TimeInterval


class ProsodyPrediction(UniversalBaseModel):
    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    A segment of text (like a word or a sentence).
    """

    time: TimeInterval
    confidence: typing.Optional[float] = pydantic.Field(default=None)
    """
    Value between `0.0` and `1.0` that indicates our transcription model's relative confidence in this text.
    """

    speaker_confidence: typing.Optional[float] = pydantic.Field(default=None)
    """
    Value between `0.0` and `1.0` that indicates our transcription model's relative confidence that this text was spoken by this speaker.
    """

    emotions: typing.List[EmotionScore] = pydantic.Field()
    """
    A high-dimensional embedding in emotion space.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
