# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .bcp_47_tag import Bcp47Tag


class TranscriptionMetadata(UniversalBaseModel):
    """
    Transcription metadata for your media file.
    """

    confidence: float = pydantic.Field()
    """
    Value between `0.0` and `1.0` indicating our transcription model's relative confidence in the transcription of your media file.
    """

    detected_language: typing.Optional[Bcp47Tag] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
