# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from .....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...types.emotion_embedding import EmotionEmbedding
from ...types.stream_bounding_box import StreamBoundingBox


class StreamModelPredictionsFacePredictionsItem(UniversalBaseModel):
    frame: typing.Optional[float] = pydantic.Field(default=None)
    """
    Frame number
    """

    time: typing.Optional[float] = pydantic.Field(default=None)
    """
    Time in seconds when face detection occurred.
    """

    bbox: typing.Optional[StreamBoundingBox] = None
    prob: typing.Optional[float] = pydantic.Field(default=None)
    """
    The predicted probability that a detected face was actually a face.
    """

    face_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Identifier for a face. Not that this defaults to `unknown` unless face identification is enabled in the face model configuration.
    """

    emotions: typing.Optional[EmotionEmbedding] = None
    facs: typing.Optional[EmotionEmbedding] = None
    descriptions: typing.Optional[EmotionEmbedding] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
