# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .audio_format_type import AudioFormatType


class AudioEncoding(UniversalBaseModel):
    """
    Encoding information about the generated audio, including the `format` and `sample_rate`.
    """

    format: AudioFormatType = pydantic.Field()
    """
    Format for the output audio.
    """

    sample_rate: int = pydantic.Field()
    """
    The sample rate (`Hz`) of the generated audio. The default sample rate is `48000 Hz`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
