# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .posted_utterance_voice import PostedUtteranceVoice


class PostedUtterance(UniversalBaseModel):
    text: str = pydantic.Field()
    """
    The input text to be synthesized into speech.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Natural language instructions describing how the synthesized speech should sound, including but not limited to tone, intonation, pacing, and accent.
    
    **This field behaves differently depending on whether a voice is specified**:
    - **Voice specified**: the description will serve as acting directions for delivery. Keep directions concise—100 characters or fewer—for best results. See our guide on [acting instructions](/docs/text-to-speech-tts/acting-instructions).
    - **Voice not specified**: the description will serve as a voice prompt for generating a voice. See our [prompting guide](/docs/text-to-speech-tts/prompting) for design tips.
    """

    voice: typing.Optional[PostedUtteranceVoice] = pydantic.Field(default=None)
    """
    The `name` or `id` associated with a **Voice** from the **Voice Library** to be used as the speaker for this and all subsequent `utterances`, until the `voice` field is updated again.
    
     See our [voices guide](/docs/text-to-speech-tts/voices) for more details on generating and specifying **Voices**.
    """

    speed: typing.Optional[float] = pydantic.Field(default=None)
    """
    Speed multiplier for the synthesized speech. Extreme values below 0.75 and above 1.5 may sometimes cause instability to the generated output.
    """

    trailing_silence: typing.Optional[float] = pydantic.Field(default=None)
    """
    Duration of trailing silence (in seconds) to add to this utterance
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
