# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .audio_encoding import AudioEncoding
from .snippet import Snippet


class ReturnGeneration(UniversalBaseModel):
    generation_id: str = pydantic.Field()
    """
    A unique ID associated with this TTS generation that can be used as context for generating consistent speech style and prosody across multiple requests.
    """

    duration: float = pydantic.Field()
    """
    Duration of the generated audio in seconds.
    """

    file_size: int = pydantic.Field()
    """
    Size of the generated audio in bytes.
    """

    encoding: AudioEncoding
    audio: str = pydantic.Field()
    """
    The generated audio output in the requested format, encoded as a base64 string.
    """

    snippets: typing.List[typing.List[Snippet]] = pydantic.Field()
    """
    A list of snippet groups where each group corresponds to an utterance in the request. Each group contains segmented snippets that represent the original utterance divided into more natural-sounding units optimized for speech delivery.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
