# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ..types.return_voice import ReturnVoice
from ..types.voice_provider import VoiceProvider
from .raw_client import AsyncRawVoicesClient, RawVoicesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VoicesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVoicesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVoicesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVoicesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        provider: VoiceProvider,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnVoice]:
        """
        Lists voices you have saved in your account, or voices from the [Voice Library](https://platform.hume.ai/tts/voice-library).

        Parameters
        ----------
        provider : VoiceProvider
            Specify the voice provider to filter voices returned by the endpoint:

            - **`HUME_AI`**: Lists preset, shared voices from Hume's [Voice Library](https://platform.hume.ai/tts/voice-library).
            - **`CUSTOM_VOICE`**: Lists custom voices created and saved to your account.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        ascending_order : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnVoice]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.tts.voices.list(
            provider="CUSTOM_VOICE",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            provider=provider,
            page_number=page_number,
            page_size=page_size,
            ascending_order=ascending_order,
            request_options=request_options,
        )

    def create(
        self, *, generation_id: str, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ReturnVoice:
        """
        Saves a new custom voice to your account using the specified TTS generation ID.

        Once saved, this voice can be reused in subsequent TTS requests, ensuring consistent speech style and prosody. For more details on voice creation, see the [Voices Guide](/docs/text-to-speech-tts/voices).

        Parameters
        ----------
        generation_id : str
            A unique ID associated with this TTS generation that can be used as context for generating consistent speech style and prosody across multiple requests.

        name : str
            Name of the voice in the `Voice Library`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnVoice
            Successful Response

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.tts.voices.create(
            generation_id="795c949a-1510-4a80-9646-7d0863b023ab",
            name="David Hume",
        )
        """
        _response = self._raw_client.create(generation_id=generation_id, name=name, request_options=request_options)
        return _response.data

    def delete(self, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a previously generated custom voice.

        Parameters
        ----------
        name : str
            Name of the voice to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.tts.voices.delete(
            name="David Hume",
        )
        """
        _response = self._raw_client.delete(name=name, request_options=request_options)
        return _response.data


class AsyncVoicesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVoicesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVoicesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVoicesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        provider: VoiceProvider,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnVoice]:
        """
        Lists voices you have saved in your account, or voices from the [Voice Library](https://platform.hume.ai/tts/voice-library).

        Parameters
        ----------
        provider : VoiceProvider
            Specify the voice provider to filter voices returned by the endpoint:

            - **`HUME_AI`**: Lists preset, shared voices from Hume's [Voice Library](https://platform.hume.ai/tts/voice-library).
            - **`CUSTOM_VOICE`**: Lists custom voices created and saved to your account.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        ascending_order : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnVoice]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.tts.voices.list(
                provider="CUSTOM_VOICE",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            provider=provider,
            page_number=page_number,
            page_size=page_size,
            ascending_order=ascending_order,
            request_options=request_options,
        )

    async def create(
        self, *, generation_id: str, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ReturnVoice:
        """
        Saves a new custom voice to your account using the specified TTS generation ID.

        Once saved, this voice can be reused in subsequent TTS requests, ensuring consistent speech style and prosody. For more details on voice creation, see the [Voices Guide](/docs/text-to-speech-tts/voices).

        Parameters
        ----------
        generation_id : str
            A unique ID associated with this TTS generation that can be used as context for generating consistent speech style and prosody across multiple requests.

        name : str
            Name of the voice in the `Voice Library`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnVoice
            Successful Response

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tts.voices.create(
                generation_id="795c949a-1510-4a80-9646-7d0863b023ab",
                name="David Hume",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            generation_id=generation_id, name=name, request_options=request_options
        )
        return _response.data

    async def delete(self, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a previously generated custom voice.

        Parameters
        ----------
        name : str
            Name of the voice to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tts.voices.delete(
                name="David Hume",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(name=name, request_options=request_options)
        return _response.data
