#ifndef TEMPLATE_H
#define TEMPLATE_H

#include <string>
#include "ValueType.h"
#include "EventType.h"
#include "SegmentType.h"
#include "Format.h"
#include "Event.h"


struct Template{
   // Declare prototype of member functions
   struct Format formattype;            // format type
   enum SegmentType segmenttype;        // segment type
   enum ValueType valuetype;            // value type indicating if VALUE_RAW or VALUE_NESTED
   enum EventType startevent;           // event to be used at the start if VALUE_NESTED type
   enum EventType endevent;             // event to be used at the endif VALUE_NESTED
   int length;                          // length of the segment (in parts not bytes)
   int multiplier;                      // multiplier. it will be 2 for maps and 1 for others
};;




const struct Template TEMPLATE_POS_FIXINT = {POS_FIXINT, SEG_SINGLE_BYTE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 0, 1};
const struct Template TEMPLATE_NEG_FIXINT = {NEG_FIXINT, SEG_SINGLE_BYTE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 0, 1};

const struct Template TEMPLATE_FIXMAP = {FIXMAP, SEG_HEADER_WITH_LENGTH_VALUE_PAIR, VALUE_NESTED, ET_MAP_START, ET_MAP_END, 0, 2};
const struct Template TEMPLATE_FIXARRAY = {FIXARRAY, SEG_HEADER_WITH_LENGTH_VALUE_PAIR, VALUE_NESTED, ET_ARRAY_START, ET_ARRAY_END, 0, 1};
const struct Template TEMPLATE_FIXSTR = {FIXSTR, SEG_HEADER_WITH_LENGTH_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 0, 1};

const struct Template TEMPLATE_NIL = {NIL , SEG_SINGLE_BYTE, VALUE_NONE_VAL, ET_NONE_EVENT, ET_NONE_EVENT, 0, 1};
const struct Template TEMPLATE_NEVER_USED = {NEVER_USED, SEG_SINGLE_BYTE, VALUE_NONE_VAL, ET_NONE_EVENT, ET_NONE_EVENT, 0, 1};

const struct Template TEMPLATE_FALSE = {FALSE_FORMAT , SEG_SINGLE_BYTE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 0, 1};
const struct Template TEMPLATE_TRUE = {TRUE_FORMAT, SEG_SINGLE_BYTE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 0, 1};

const struct Template TEMPLATE_BIN_8 = {BIN_8, SEG_VARIABLE_LENGTH_VALUE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 1, 1};
const struct Template TEMPLATE_BIN_16 = {BIN_16, SEG_VARIABLE_LENGTH_VALUE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 2, 1};
const struct Template TEMPLATE_BIN_32 = {BIN_32, SEG_VARIABLE_LENGTH_VALUE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 4, 1};

const struct Template TEMPLATE_EXT_8 = {EXT_8, SEG_EXT_FORMAT, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 1, 1};
const struct Template TEMPLATE_EXT_16 = {EXT_16, SEG_EXT_FORMAT, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 2, 1};
const struct Template TEMPLATE_EXT_32 = {EXT_32, SEG_EXT_FORMAT, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 4, 1};


const struct Template TEMPLATE_FLOAT_32 = {FLOAT_32, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 4, 1};
const struct Template TEMPLATE_FLOAT_64 = {FLOAT_64, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 8, 1};

const struct Template TEMPLATE_UINT_8 = {UINT_8, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 1, 1};
const struct Template TEMPLATE_UINT_16 = {UINT_16, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 2, 1};
const struct Template TEMPLATE_UINT_32 = {UINT_32, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 4, 1};
const struct Template TEMPLATE_UINT_64 = {UINT_64, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 8, 1};

const struct Template TEMPLATE_INT_8 = {INT_8, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 1, 1};
const struct Template TEMPLATE_INT_16 = {INT_16, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 2, 1};
const struct Template TEMPLATE_INT_32 = {INT_32, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 4, 1};
const struct Template TEMPLATE_INT_64 = {INT_64, SEG_HEADER_VALUE_PAIR, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 8, 1};

const struct Template TEMPLATE_FIXEXT_1 = {FIXEXT_1, SEG_FIXED_EXT_FORMAT, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 1, 1};
const struct Template TEMPLATE_FIXEXT_2 = {FIXEXT_2, SEG_FIXED_EXT_FORMAT, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 2, 1};
const struct Template TEMPLATE_FIXEXT_4 = {FIXEXT_4, SEG_FIXED_EXT_FORMAT, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 4, 1};
const struct Template TEMPLATE_FIXEXT_8 = {FIXEXT_8, SEG_FIXED_EXT_FORMAT, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 8, 1};
const struct Template TEMPLATE_FIXEXT_16 = {FIXEXT_16, SEG_FIXED_EXT_FORMAT, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 16, 1};

const struct Template TEMPLATE_STR_8 = {STR_8, SEG_VARIABLE_LENGTH_VALUE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 1, 1};
const struct Template TEMPLATE_STR_16 = {STR_16, SEG_VARIABLE_LENGTH_VALUE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 2, 1};
const struct Template TEMPLATE_STR_32 = {STR_32, SEG_VARIABLE_LENGTH_VALUE, VALUE_RAW, ET_NONE_EVENT, ET_NONE_EVENT, 4, 1};

const struct Template TEMPLATE_ARRAY_16 = {ARRAY_16, SEG_VARIABLE_LENGTH_VALUE, VALUE_NESTED, ET_ARRAY_START, ET_ARRAY_END, 2, 1};
const struct Template TEMPLATE_ARRAY_32 = {ARRAY_32, SEG_VARIABLE_LENGTH_VALUE, VALUE_NESTED, ET_ARRAY_START, ET_ARRAY_END, 4, 1};

const struct Template TEMPLATE_MAP_16 = {MAP_16, SEG_VARIABLE_LENGTH_VALUE, VALUE_NESTED, ET_MAP_START, ET_MAP_END, 2, 2};
const struct Template TEMPLATE_MAP_32 = {MAP_32, SEG_VARIABLE_LENGTH_VALUE, VALUE_NESTED, ET_MAP_START, ET_MAP_END, 4, 2};


const struct Template TEMPLATE_ERROR = {NONE_FRMT, SEG_NONE_SEG, VALUE_NONE_VAL, ET_NONE_EVENT, ET_NONE_EVENT, 2, 2};
const struct Template TEMPLATE_NONE = {NONE_FRMT, SEG_NONE_SEG, VALUE_NONE_VAL, ET_NONE_EVENT, ET_NONE_EVENT, 4, 2};

#endif 